/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class LoggerPlus {
    private final Logger logger;

    public LoggerPlus(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    private static String formattedMessage(String format, Object ... values) {
        return String.format(format, values);
    }

    public void debug(String format, Object ... values) {
        this.debug(LoggerPlus.formattedMessage(format, values));
    }

    public void debug(Supplier<String> message) {
        if (this.logger.isDebugEnabled()) {
            Optional.ofNullable(message).ifPresent(___message -> this.logger.debug((String)___message.get()));
        }
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String format, Object ... values) {
        this.info(LoggerPlus.formattedMessage(format, values));
    }

    public void info(Supplier<String> message) {
        if (this.logger.isInfoEnabled()) {
            Optional.ofNullable(message).ifPresent(___message -> this.logger.info((String)___message.get()));
        }
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(Supplier<String> message) {
        if (this.logger.isErrorEnabled()) {
            Optional.ofNullable(message).ifPresent(___message -> this.logger.error((String)___message.get()));
        }
    }

    public void error(String format, Object ... values) {
        this.error(LoggerPlus.formattedMessage(format, values));
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void warn(String format, Object ... values) {
        this.warn(LoggerPlus.formattedMessage(format, values));
    }

    public void warn(Supplier<String> message) {
        if (this.logger.isWarnEnabled()) {
            Optional.ofNullable(message).ifPresent(___message -> this.logger.warn((String)___message.get()));
        }
    }

    public void trace(String message) {
        this.logger.trace(message);
    }

    public void trace(String format, Object ... values) {
        this.trace(LoggerPlus.formattedMessage(format, values));
    }

    public void trace(Supplier<String> message) {
        if (this.logger.isTraceEnabled()) {
            Optional.ofNullable(message).ifPresent(___message -> this.logger.trace((String)___message.get()));
        }
    }

    @Deprecated
    public MethodLogger logByMethodCall(String methodName, boolean withHeader) {
        return new MethodLogger(methodName, this, withHeader);
    }

    @Deprecated
    public MethodLogger logByMethodCall(String methodName) {
        return this.logByMethodCall(methodName, true);
    }

    public GroupLogger groupLog(String groupName, boolean withHeader) {
        return new GroupLogger(groupName, this, withHeader);
    }

    public GroupLogger groupLog(String groupName) {
        return this.groupLog(groupName, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getStackTraceAsString(Exception exception) {
        if (null != exception) {
            try (StringWriter sWriter = new StringWriter();){
                PrintWriter pWriter = new PrintWriter(sWriter);
                try {
                    exception.printStackTrace(pWriter);
                    String string = sWriter.toString();
                    pWriter.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        pWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    @Deprecated
    public static class MethodLogger
    extends GroupLogger {
        public MethodLogger(String methodName, LoggerPlus logPlus, boolean withHeader) {
            super(methodName, logPlus, withHeader);
        }
    }

    public static class GroupLogger
    implements AutoCloseable {
        private final LoggerPlus logPlus;
        private final String groupName;
        private final boolean withHeader;
        private final BiFunction<String, String, String> messageBlock = (___methodName, ___message) -> new StringJoiner(" ").add((CharSequence)___methodName).add((CharSequence)___message).toString();

        public GroupLogger(String groupName, LoggerPlus logPlus, boolean withHeader) {
            this.groupName = groupName;
            this.logPlus = logPlus;
            this.withHeader = withHeader;
            if (withHeader) {
                this.logPlus.debug(() -> this.messageBlock.apply(this.groupName, "[BEGIN]"));
            }
        }

        @Override
        public void close() {
            if (this.withHeader) {
                this.logPlus.debug(() -> this.messageBlock.apply(this.groupName, "[END]"));
            }
        }

        public void debug(String message) {
            this.logPlus.debug(this.messageBlock.apply(this.groupName, message));
        }

        public void debug(Supplier<String> message) {
            this.logPlus.debug(() -> this.messageBlock.apply(this.groupName, (String)message.get()));
        }

        public void debug(String format, Object ... values) {
            this.debug(LoggerPlus.formattedMessage(format, values));
        }

        public void info(String message) {
            this.logPlus.info(this.messageBlock.apply(this.groupName, message));
        }

        public void info(Supplier<String> message) {
            this.logPlus.info(() -> this.messageBlock.apply(this.groupName, (String)message.get()));
        }

        public void info(String format, Object ... values) {
            this.info(LoggerPlus.formattedMessage(format, values));
        }

        public void error(String message) {
            this.logPlus.error(this.messageBlock.apply(this.groupName, message));
        }

        public void error(Supplier<String> message) {
            this.logPlus.error(() -> this.messageBlock.apply(this.groupName, (String)message.get()));
        }

        public void error(String format, Object ... values) {
            this.error(LoggerPlus.formattedMessage(format, values));
        }

        public void warn(String message) {
            this.logPlus.warn(this.messageBlock.apply(this.groupName, message));
        }

        public void warn(Supplier<String> message) {
            this.logPlus.warn(() -> this.messageBlock.apply(this.groupName, (String)message.get()));
        }

        public void warn(String format, Object ... values) {
            this.warn(LoggerPlus.formattedMessage(format, values));
        }

        public void trace(String message) {
            this.logPlus.trace(this.messageBlock.apply(this.groupName, message));
        }

        public void trace(Supplier<String> message) {
            this.logPlus.trace(() -> this.messageBlock.apply(this.groupName, (String)message.get()));
        }

        public void trace(String format, Object ... values) {
            this.trace(LoggerPlus.formattedMessage(format, values));
        }
    }
}

