/*
 * Decompiled with CFR 0.152.
 */
package xyz.teogramm.oasth;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.teogramm.oasth.base.BusRoute;
import xyz.teogramm.oasth.base.BusStop;
import xyz.teogramm.oasth.live.BusArrival;
import xyz.teogramm.oasth.live.BusLocation;
import xyz.teogramm.oasth.live.Coordinates;
import xyz.teogramm.oasth.util.OasthAPIFetcher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lxyz/teogramm/oasth/OasthLive;", "", "()V", "Companion", "oasth"})
public final class OasthLive {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final List<Coordinates> getRoutePoints(int routeID) {
        return Companion.getRoutePoints(routeID);
    }

    @JvmStatic
    @NotNull
    public static final List<Coordinates> getRoutePoints(@NotNull BusRoute route) {
        return Companion.getRoutePoints(route);
    }

    @JvmStatic
    @NotNull
    public static final List<BusArrival> getStopArrivals(int stopID) {
        return Companion.getStopArrivals(stopID);
    }

    @JvmStatic
    @NotNull
    public static final List<BusArrival> getStopArrivals(@NotNull BusStop stop) {
        return Companion.getStopArrivals(stop);
    }

    @JvmStatic
    @NotNull
    public static final List<BusLocation> getBusLocations(int routeID) {
        return Companion.getBusLocations(routeID);
    }

    @JvmStatic
    @NotNull
    public static final List<BusLocation> getBusLocations(@NotNull BusRoute route) {
        return Companion.getBusLocations(route);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lxyz/teogramm/oasth/OasthLive$Companion;", "", "()V", "getBusLocations", "", "Lxyz/teogramm/oasth/live/BusLocation;", "routeID", "", "route", "Lxyz/teogramm/oasth/base/BusRoute;", "getRoutePoints", "Lxyz/teogramm/oasth/live/Coordinates;", "getStopArrivals", "Lxyz/teogramm/oasth/live/BusArrival;", "stopID", "stop", "Lxyz/teogramm/oasth/base/BusStop;", "oasth"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Coordinates> getRoutePoints(int routeID) {
            void $this$mapNotNullTo$iv$iv;
            List<Map<String, String>> rawData = OasthAPIFetcher.Companion.fetchFromSimpleJSONEndpoint("getRouteDetailPerRoute", String.valueOf(routeID));
            Iterable $this$mapNotNull$iv = rawData;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Coordinates coordinates;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map it = (Map)element$iv$iv;
                boolean bl2 = false;
                if (it.keySet().containsAll(CollectionsKt.listOf((Object[])new String[]{"x", "y"}))) {
                    Object v = it.get("x");
                    Intrinsics.checkNotNull(v);
                    String string = (String)v;
                    boolean bl3 = false;
                    double d = Double.parseDouble(string);
                    Object v2 = it.get("y");
                    Intrinsics.checkNotNull(v2);
                    string = (String)v2;
                    bl3 = false;
                    coordinates = new Coordinates(d, Double.parseDouble(string));
                } else {
                    coordinates = null;
                }
                if (coordinates == null) continue;
                Coordinates coordinates2 = coordinates;
                boolean bl4 = false;
                boolean bl5 = false;
                Coordinates it$iv$iv = coordinates2;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<Coordinates> getRoutePoints(@NotNull BusRoute route) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            return this.getRoutePoints(route.getInternalId());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<BusArrival> getStopArrivals(int stopID) {
            void $this$mapNotNullTo$iv$iv;
            List<Map<String, String>> rawData = OasthAPIFetcher.Companion.fetchFromSimpleJSONEndpoint("getStopArrivals", String.valueOf(stopID));
            List requiredKeys = CollectionsKt.listOf((Object[])new String[]{"route_code", "veh_code", "btime2"});
            Iterable $this$mapNotNull$iv = rawData;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BusArrival busArrival;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map it = (Map)element$iv$iv;
                boolean bl2 = false;
                if (it.keySet().containsAll(requiredKeys)) {
                    Object v = it.get("route_code");
                    Intrinsics.checkNotNull(v);
                    String string = (String)v;
                    boolean bl3 = false;
                    int n = Integer.parseInt(string);
                    Object v2 = it.get("veh_code");
                    Intrinsics.checkNotNull(v2);
                    String string2 = (String)v2;
                    Object v3 = it.get("btime2");
                    Intrinsics.checkNotNull(v3);
                    string = (String)v3;
                    bl3 = false;
                    busArrival = new BusArrival(n, string2, Integer.parseInt(string));
                } else {
                    busArrival = null;
                }
                if (busArrival == null) continue;
                BusArrival busArrival2 = busArrival;
                boolean bl4 = false;
                boolean bl5 = false;
                BusArrival it$iv$iv = busArrival2;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<BusArrival> getStopArrivals(@NotNull BusStop stop) {
            Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
            return this.getStopArrivals(stop.getInternalId());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<BusLocation> getBusLocations(int routeID) {
            void $this$mapNotNullTo$iv$iv;
            List<Map<String, String>> rawData = OasthAPIFetcher.Companion.fetchFromSimpleJSONEndpoint("getBusLocation", String.valueOf(routeID));
            List requiredKeys = CollectionsKt.listOf((Object[])new String[]{"VEH_NO", "CS_DATE", "CS_LAT", "CS_LNG", "ROUTE_CODE"});
            Iterable $this$mapNotNull$iv = rawData;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BusLocation busLocation;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map it = (Map)element$iv$iv;
                boolean bl2 = false;
                if (it.keySet().containsAll(requiredKeys)) {
                    Object v = it.get("CS_LNG");
                    Intrinsics.checkNotNull(v);
                    String string = (String)v;
                    boolean bl3 = false;
                    double d = Double.parseDouble(string);
                    Object v2 = it.get("CS_LAT");
                    Intrinsics.checkNotNull(v2);
                    string = (String)v2;
                    bl3 = false;
                    Coordinates locationCoordinates = new Coordinates(d, Double.parseDouble(string));
                    Object v3 = it.get("CS_DATE");
                    Intrinsics.checkNotNull(v3);
                    LocalDateTime time = LocalDateTime.parse(StringsKt.replace$default((String)((String)v3), (String)" ", (String)"T", (boolean)false, (int)4, null));
                    Object v4 = it.get("VEH_NO");
                    Intrinsics.checkNotNull(v4);
                    String string2 = (String)v4;
                    LocalDateTime localDateTime = time;
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"time");
                    Object v5 = it.get("ROUTE_CODE");
                    Intrinsics.checkNotNull(v5);
                    String string3 = (String)v5;
                    boolean bl4 = false;
                    busLocation = new BusLocation(string2, localDateTime, locationCoordinates, Integer.parseInt(string3));
                } else {
                    busLocation = null;
                }
                if (busLocation == null) continue;
                BusLocation busLocation2 = busLocation;
                boolean bl5 = false;
                boolean bl6 = false;
                BusLocation it$iv$iv = busLocation2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<BusLocation> getBusLocations(@NotNull BusRoute route) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            return this.getBusLocations(route.getInternalId());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

