/**
 * Copyright (C) 2017 Mikhail Frolov
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package xyz.truenight.rxinapps.model;

import android.support.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ProductType {

    public static final String MANAGED = "inapp";
    public static final String SUBSCRIPTION = "subs";

    private ProductType() {

    }

    public static boolean isManaged(String productType) {
        return productType.equalsIgnoreCase(ProductType.MANAGED);
    }

    public static boolean isSubscription(String productType) {
        return productType.equalsIgnoreCase(ProductType.SUBSCRIPTION);
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({MANAGED, SUBSCRIPTION})
    public @interface Annotation {
    }
}
