/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.concurrent.Semaphore;
import xyz.truenight.rxinapps.RxInApps;
import xyz.truenight.rxinapps.exception.InitializationException;

class ConnectionOnSubscribe
implements SingleOnSubscribe<IInAppBillingService> {
    private static final String TAG = RxInApps.TAG;
    private final RxInApps context;
    private IInAppBillingService service;

    public static ConnectionOnSubscribe create(RxInApps context) {
        return new ConnectionOnSubscribe(context);
    }

    private ConnectionOnSubscribe(RxInApps context) {
        this.context = context;
    }

    private boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public void subscribe(final SingleEmitter<IInAppBillingService> emitter) throws Exception {
        final boolean mainThread = this.isMainThread();
        final Semaphore semaphore = mainThread ? null : new Semaphore(0);
        final ServiceConnection serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Log.d((String)TAG, (String)"onServiceConnected");
                ConnectionOnSubscribe.this.service = IInAppBillingService.Stub.asInterface(iBinder);
                if (mainThread) {
                    emitter.onSuccess((Object)ConnectionOnSubscribe.this.service);
                } else {
                    semaphore.release();
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                Log.d((String)TAG, (String)"onServiceDisconnected");
                ConnectionOnSubscribe.this.service = null;
            }
        };
        try {
            this.context.getContext().bindService(new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending"), serviceConnection, 1);
            Log.d((String)TAG, (String)"Created new service connection");
        }
        catch (Exception e) {
            emitter.onError((Throwable)new InitializationException("Can NOT initialize InAppBillingService", e));
            return;
        }
        emitter.setCancellable(new Cancellable(){

            public void cancel() throws Exception {
                ConnectionOnSubscribe.this.context.getContext().unbindService(serviceConnection);
            }
        });
        if (!mainThread) {
            semaphore.acquireUninterruptibly();
            emitter.onSuccess((Object)this.service);
        }
    }
}

