/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.util.Locale;
import java.util.Map;
import xyz.truenight.rxinapps.RxInApps;
import xyz.truenight.rxinapps.exception.ConsumeFailedException;
import xyz.truenight.rxinapps.exception.PurchaseNotFoundException;
import xyz.truenight.rxinapps.model.Purchase;
import xyz.truenight.utils.Utils;

class ConsumePurchaseOnSubscribe
implements SingleOnSubscribe<Purchase> {
    private static final String TAG = RxInApps.TAG;
    private RxInApps context;
    private IInAppBillingService billingService;
    private String packageName;
    private Map<String, Purchase> map;
    private String productId;

    public static ConsumePurchaseOnSubscribe create(RxInApps context, IInAppBillingService billingService, String packageName, Map<String, Purchase> map, String productId) {
        return new ConsumePurchaseOnSubscribe(context, billingService, packageName, map, productId);
    }

    public ConsumePurchaseOnSubscribe(RxInApps context, IInAppBillingService billingService, String packageName, Map<String, Purchase> map, String productId) {
        this.context = context;
        this.billingService = billingService;
        this.packageName = packageName;
        this.map = map;
        this.productId = productId;
    }

    public void subscribe(SingleEmitter<Purchase> emitter) throws Exception {
        try {
            Purchase purchase = this.map.get(this.productId);
            Log.d((String)TAG, (String)("Transaction details is:" + (purchase == null ? "null" : "not null")));
            if (purchase != null && !Utils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                int response = this.billingService.consumePurchase(3, this.packageName, purchase.getPurchaseToken());
                Log.d((String)TAG, (String)("Consume response code:" + response));
                if (response != 0) {
                    throw new ConsumeFailedException(String.format(Locale.getDefault(), "Failed to consume %s: RESPONSE_CODE=%d", this.productId, response));
                }
            } else {
                throw new PurchaseNotFoundException("Purchase for consuming not found");
            }
            this.context.removePurchaseFromCache(this.productId, "inapp");
            Log.d((String)TAG, (String)("Successfully consumed " + this.productId + " purchase."));
            emitter.onSuccess((Object)purchase);
        }
        catch (Exception e) {
            emitter.onError((Throwable)e);
        }
    }
}

