/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.util.Log;
import io.reactivex.functions.Cancellable;
import java.lang.reflect.Type;
import java.util.Map;
import xyz.truenight.rxinapps.RxInApps;
import xyz.truenight.rxinapps.exception.BillingUnavailableException;
import xyz.truenight.rxinapps.exception.DeveloperErrorException;
import xyz.truenight.rxinapps.exception.InAppBillingException;
import xyz.truenight.rxinapps.exception.ItemUnavailableException;
import xyz.truenight.rxinapps.exception.MerchantIdException;
import xyz.truenight.rxinapps.exception.PayloadException;
import xyz.truenight.rxinapps.exception.PurchaseCanceledException;
import xyz.truenight.rxinapps.exception.PurchaseFailedException;
import xyz.truenight.rxinapps.exception.SignatureException;
import xyz.truenight.rxinapps.model.ProductType;
import xyz.truenight.rxinapps.model.Purchase;
import xyz.truenight.utils.Utils;

public class HiddenActivity
extends Activity {
    private static final String TAG = RxInApps.TAG;
    private static final int PURCHASE_FLOW_REQUEST_CODE = 65535;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PendingIntent pendingIntent = (PendingIntent)this.getIntent().getParcelableExtra("BUY_INTENT");
        RxInApps rxInApps = RxInApps.with((Context)this);
        if (!rxInApps.bindPurchaseUnsubscribe(new Cancellable(){

            public void cancel() throws Exception {
                HiddenActivity.super.finish();
            }
        })) {
            super.finish();
        }
        try {
            this.startIntentSenderForResult(pendingIntent.getIntentSender(), 65535, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            rxInApps.deliverPurchaseError(e);
            super.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.handleActivityResult(requestCode, resultCode, data)) {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 65535) {
            return false;
        }
        if (data == null) {
            Log.e((String)TAG, (String)"handleActivityResult: data is null!");
            return false;
        }
        RxInApps rxInApps = RxInApps.with((Context)this);
        if (rxInApps.checkPurchaseSubscriber()) {
            Log.e((String)TAG, (String)"", (Throwable)new InAppBillingException("Subscriber for purchase is unsubscribed or NULL"));
            super.finish();
            return true;
        }
        int responseCode = data.getIntExtra("RESPONSE_CODE", 0);
        Log.d((String)TAG, (String)String.format("resultCode = %d, responseCode = %d", resultCode, responseCode));
        String purchasePayload = this.getIntent().getStringExtra("PURCHASE_PAYLOAD");
        if (resultCode == -1 && responseCode == 0) {
            this.handleOkResponse(data, purchasePayload, rxInApps);
        } else if (responseCode == 7) {
            this.handleAlreadyOwnedResponse(data, purchasePayload, rxInApps);
        } else {
            PurchaseFailedException throwable;
            switch (responseCode) {
                case 1: {
                    throwable = new PurchaseCanceledException();
                    break;
                }
                case 3: {
                    throwable = new BillingUnavailableException();
                    break;
                }
                case 4: {
                    throwable = new ItemUnavailableException();
                    break;
                }
                case 5: {
                    throwable = new DeveloperErrorException();
                    break;
                }
                case 6: {
                    throwable = new PurchaseFailedException("Fatal error during the API action", responseCode);
                    break;
                }
                default: {
                    throwable = new PurchaseFailedException(responseCode);
                }
            }
            rxInApps.deliverPurchaseError(throwable);
            super.finish();
        }
        return true;
    }

    private void handleOkResponse(Intent data, String purchasePayload, RxInApps rxInApps) {
        String purchaseData = data.getStringExtra("INAPP_PURCHASE_DATA");
        String dataSignature = data.getStringExtra("INAPP_DATA_SIGNATURE");
        try {
            Purchase purchase = (Purchase)rxInApps.getParser().fromString(purchaseData, (Type)((Object)Purchase.class));
            purchase.setPurchaseSignature(dataSignature);
            purchase.setRawResponse(purchaseData);
            String productId = purchase.getProductId();
            String developerPayload = purchase.getDeveloperPayload();
            if (Utils.equal((Object)purchasePayload, (Object)developerPayload)) {
                if (!RxInApps.verifyPurchaseSignature(productId, purchaseData, dataSignature)) {
                    throw new PurchaseFailedException(new SignatureException("Public key signature does NOT match"));
                }
            } else {
                throw new PurchaseFailedException(new PayloadException(String.format("Payload mismatch: %s != %s", purchasePayload, developerPayload)));
            }
            String productType = (String)Utils.first((Object[])purchasePayload.split(":"));
            rxInApps.putPurchaseToCache(purchase, productType);
            rxInApps.deliverPurchaseResult(purchase);
            super.finish();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            rxInApps.deliverPurchaseError(e);
            super.finish();
        }
    }

    private void handleAlreadyOwnedResponse(Intent data, String purchasePayload, RxInApps rxInApps) {
        String purchaseData = data.getStringExtra("INAPP_PURCHASE_DATA");
        String dataSignature = data.getStringExtra("INAPP_DATA_SIGNATURE");
        try {
            Purchase purchase = (Purchase)rxInApps.getParser().fromString(purchaseData, (Type)((Object)Purchase.class));
            purchase.setPurchaseSignature(dataSignature);
            purchase.setRawResponse(purchaseData);
            String productId = purchase.getProductId();
            String developerPayload = purchase.getDeveloperPayload();
            if (Utils.equal((Object)purchasePayload, (Object)developerPayload)) {
                String productType = (String)Utils.first((Object[])purchasePayload.split(":"));
                Map map = (Map)rxInApps.getStorage().get(productType);
                if (!Utils.containsKey((Map)map, (Object)productId)) {
                    rxInApps.putPurchaseToCache(purchase, productType);
                }
                if (ProductType.isManaged(productType) && !RxInApps.checkMerchantTransactionDetails(purchase)) {
                    throw new PurchaseFailedException(new MerchantIdException("Invalid or tampered merchant id!"));
                }
            } else {
                throw new PurchaseFailedException(new PayloadException(String.format("Payload mismatch: %s != %s", purchasePayload, developerPayload)));
            }
            purchase.setRestored(true);
            rxInApps.deliverPurchaseResult(purchase);
            super.finish();
        }
        catch (Exception e) {
            rxInApps.deliverPurchaseError(e);
            super.finish();
        }
    }

    public void finish() {
        RxInApps.with((Context)this).deliverPurchaseError(new PurchaseCanceledException());
        super.finish();
    }
}

