/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.android.vending.billing.IInAppBillingService;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import xyz.truenight.rxinapps.HiddenActivity;
import xyz.truenight.rxinapps.RxInApps;
import xyz.truenight.rxinapps.exception.BillingUnavailableException;
import xyz.truenight.rxinapps.exception.DeveloperErrorException;
import xyz.truenight.rxinapps.exception.ItemUnavailableException;
import xyz.truenight.rxinapps.exception.MerchantIdException;
import xyz.truenight.rxinapps.exception.PurchaseCanceledException;
import xyz.truenight.rxinapps.exception.PurchaseFailedException;
import xyz.truenight.rxinapps.model.ProductType;
import xyz.truenight.rxinapps.model.Purchase;
import xyz.truenight.utils.Utils;

class PurchaseOnSubscribe
implements SingleOnSubscribe<Purchase> {
    private RxInApps context;
    private IInAppBillingService billingService;
    private String packageName;
    private String productId;
    private String productType;
    private AtomicReference<SingleEmitter<Purchase>> purchaseSubscriber;

    public static PurchaseOnSubscribe create(RxInApps context, IInAppBillingService billingService, String packageName, String productId, String productType, AtomicReference<SingleEmitter<Purchase>> purchaseSubscriber) {
        return new PurchaseOnSubscribe(context, billingService, packageName, productId, productType, purchaseSubscriber);
    }

    public PurchaseOnSubscribe(RxInApps context, IInAppBillingService billingService, String packageName, String productId, String productType, AtomicReference<SingleEmitter<Purchase>> purchaseSubscriber) {
        this.context = context;
        this.billingService = billingService;
        this.packageName = packageName;
        this.productId = productId;
        this.productType = productType;
        this.purchaseSubscriber = purchaseSubscriber;
    }

    public void subscribe(SingleEmitter<Purchase> emitter) throws Exception {
        block16: {
            try {
                String purchasePayload = this.productType + ":" + UUID.randomUUID();
                this.purchaseSubscriber.set(emitter);
                Bundle bundle = this.billingService.getBuyIntent(3, this.packageName, this.productId, this.productType, purchasePayload);
                if (bundle != null) {
                    int responseCode = bundle.getInt("RESPONSE_CODE");
                    if (responseCode == 0) {
                        PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("BUY_INTENT");
                        if (pendingIntent != null) {
                            Context context = this.context.getContext();
                            context.startActivity(new Intent(context, HiddenActivity.class).addFlags(0x10000000).putExtra("BUY_INTENT", (Parcelable)pendingIntent).putExtra("PURCHASE_PAYLOAD", purchasePayload));
                            break block16;
                        }
                        throw new PurchaseFailedException(new NullPointerException("Buy intent is NULL"));
                    }
                    if (responseCode == 7) {
                        Purchase purchase;
                        Map map = (Map)this.context.getStorage().get(this.productType);
                        if (Utils.containsKey((Map)map, (Object)this.productId)) {
                            purchase = (Purchase)map.get(this.productId);
                        } else {
                            this.context.loadPurchasesByType(this.billingService, this.productType).compose(this.context.toMapAndCache(this.productType)).subscribe();
                            map = (Map)this.context.getStorage().get(this.productType);
                            purchase = (Purchase)map.get(this.productId);
                        }
                        if (ProductType.isManaged(this.productType) && !RxInApps.checkMerchantTransactionDetails(purchase)) {
                            throw new PurchaseFailedException(new MerchantIdException("Invalid or tampered merchant id!"));
                        }
                        purchase.setRestored(true);
                        emitter.onSuccess((Object)purchase);
                        break block16;
                    }
                    switch (responseCode) {
                        case 1: {
                            throw new PurchaseCanceledException();
                        }
                        case 3: {
                            throw new BillingUnavailableException();
                        }
                        case 4: {
                            throw new ItemUnavailableException();
                        }
                        case 5: {
                            throw new DeveloperErrorException();
                        }
                        case 6: {
                            throw new PurchaseFailedException("Fatal error during the API action", responseCode);
                        }
                    }
                    throw new PurchaseFailedException(responseCode);
                }
                throw new PurchaseFailedException(new NullPointerException("Bundle is NULL"));
            }
            catch (Throwable th) {
                emitter.onError(th);
            }
        }
    }
}

