/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.os.Bundle;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import xyz.truenight.rxinapps.RxInApps;
import xyz.truenight.rxinapps.exception.LoadFailedException;
import xyz.truenight.rxinapps.model.Purchase;
import xyz.truenight.rxinapps.util.Parser;
import xyz.truenight.utils.Utils;

class PurchasedOnSubscribe
implements SingleOnSubscribe<List<Purchase>> {
    private static final String TAG = RxInApps.TAG;
    private IInAppBillingService billingService;
    private String packageName;
    private Parser parser;
    private String type;

    public static PurchasedOnSubscribe create(IInAppBillingService billingService, String packageName, Parser parser, String type) {
        return new PurchasedOnSubscribe(billingService, packageName, parser, type);
    }

    public PurchasedOnSubscribe(IInAppBillingService billingService, String packageName, Parser parser, String type) {
        this.billingService = billingService;
        this.packageName = packageName;
        this.parser = parser;
        this.type = type;
    }

    public void subscribe(SingleEmitter<List<Purchase>> emitter) throws Exception {
        try {
            ArrayList<Purchase> list;
            Bundle bundle = this.billingService.getPurchases(3, this.packageName, this.type, null);
            if (bundle.getInt("RESPONSE_CODE") == 0) {
                ArrayList purchaseList = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
                ArrayList signatureList = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
                list = new ArrayList<Purchase>(Utils.sizeOf((Collection)purchaseList));
                if (purchaseList != null) {
                    for (int i = 0; i < purchaseList.size(); ++i) {
                        String jsonData = (String)purchaseList.get(i);
                        Purchase purchase = (Purchase)this.parser.fromString(jsonData, (Type)((Object)Purchase.class));
                        String signature = signatureList != null && signatureList.size() > i ? (String)signatureList.get(i) : null;
                        purchase.setPurchaseSignature(signature);
                        purchase.setRawResponse(jsonData);
                        list.add(purchase);
                    }
                }
            } else {
                throw new LoadFailedException("Failed to load purchases: RESPONSE_CODE=" + bundle.getInt("RESPONSE_CODE"));
            }
            emitter.onSuccess(list);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            emitter.onError((Throwable)e);
        }
    }
}

