/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.android.vending.billing.IInAppBillingService;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.functions.Action;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import xyz.truenight.rxinapps.ConnectionOnSubscribe;
import xyz.truenight.rxinapps.ConsumePurchaseOnSubscribe;
import xyz.truenight.rxinapps.ContextHolder;
import xyz.truenight.rxinapps.PurchaseOnSubscribe;
import xyz.truenight.rxinapps.PurchasedOnSubscribe;
import xyz.truenight.rxinapps.RxUtils;
import xyz.truenight.rxinapps.SkuDetailsOnSubscribe;
import xyz.truenight.rxinapps.exception.ProductNotFoundException;
import xyz.truenight.rxinapps.model.Purchase;
import xyz.truenight.rxinapps.model.SkuDetails;
import xyz.truenight.rxinapps.util.GsonParser;
import xyz.truenight.rxinapps.util.HawkStorage;
import xyz.truenight.rxinapps.util.Parser;
import xyz.truenight.rxinapps.util.Security;
import xyz.truenight.rxinapps.util.Storage;
import xyz.truenight.utils.Utils;

public class RxInApps
extends ContextHolder {
    public static final String TAG = RxInApps.class.getSimpleName();
    public static final String VERSION = "v1";
    private static final String LAST_LOAD = ":LAST_LOAD";
    private static final Date DATE_MERCHANT_LIMIT_1 = new Date(2012, 12, 5);
    private static final Date DATE_MERCHANT_LIMIT_2 = new Date(2015, 7, 20);
    private static String licenseKey;
    private static String merchantId;
    private static RxInApps instance;
    private final String packageName;
    private final Storage storage;
    private final long timeout;
    private final long cacheLifetime;
    private final Parser parser;
    private final AtomicReference<SingleEmitter<Purchase>> purchaseSubscriber = new AtomicReference();

    public static void init(Builder builder) {
        instance = new RxInApps(builder);
        licenseKey = builder.getLicenseKey();
        merchantId = builder.getMerchantId();
    }

    public static synchronized RxInApps with(Context context) {
        if (instance == null) {
            instance = new RxInApps(new Builder(context));
        }
        return instance;
    }

    private RxInApps(Builder builder) {
        super(builder.getContext());
        this.timeout = builder.getTimeout();
        this.cacheLifetime = builder.getCacheLifetime();
        this.parser = builder.getParser();
        this.packageName = this.getContext().getApplicationContext().getPackageName();
        this.storage = builder.getStorage();
    }

    Parser getParser() {
        return this.parser;
    }

    Storage getStorage() {
        return this.storage;
    }

    public static boolean isIabServiceAvailable(Context context) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent("com.android.vending.billing.InAppBillingService.BIND"), 0);
        return list.size() > 0;
    }

    public static boolean isValid(Purchase purchase) {
        return RxInApps.verifyPurchaseSignature(purchase.getProductId(), purchase.getRawResponse(), purchase.getPurchaseSignature()) && RxInApps.checkMerchantTransactionDetails(purchase);
    }

    static boolean verifyPurchaseSignature(String productId, String purchaseData, String dataSignature) {
        try {
            return Utils.isEmpty((CharSequence)licenseKey) || Security.verifyPurchase(productId, licenseKey, purchaseData, dataSignature);
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean checkMerchantTransactionDetails(Purchase details) {
        if (merchantId == null) {
            return true;
        }
        if (details.getPurchaseTime().before(DATE_MERCHANT_LIMIT_1)) {
            return true;
        }
        if (details.getPurchaseTime().after(DATE_MERCHANT_LIMIT_2)) {
            return true;
        }
        if (details.getOrderId() == null || details.getOrderId().trim().length() == 0) {
            return false;
        }
        int index = details.getOrderId().indexOf(46);
        if (index <= 0) {
            return false;
        }
        String merchantId = details.getOrderId().substring(0, index);
        return merchantId.compareTo(RxInApps.merchantId) == 0;
    }

    public Single<IInAppBillingService> initialization() {
        return Single.create((SingleOnSubscribe)ConnectionOnSubscribe.create(this)).timeout(this.timeout, TimeUnit.MILLISECONDS);
    }

    Single<List<Purchase>> loadPurchasesByType(final String productType) {
        return this.initialization().flatMap((Function)new Function<IInAppBillingService, SingleSource<? extends List<Purchase>>>(){

            public SingleSource<? extends List<Purchase>> apply(IInAppBillingService billingService) throws Exception {
                return RxInApps.this.loadPurchasesByType(billingService, productType);
            }
        });
    }

    Single<List<Purchase>> loadPurchasesByType(IInAppBillingService billingService, String productType) {
        return Single.create((SingleOnSubscribe)PurchasedOnSubscribe.create(billingService, this.packageName, this.parser, productType));
    }

    private Single<Map<String, Purchase>> purchasesByTypeMap(final String productType) {
        return Single.defer((Callable)new Callable<SingleSource<? extends Map<String, Purchase>>>(){

            @Override
            public SingleSource<? extends Map<String, Purchase>> call() throws Exception {
                Map map;
                Long lastLoad = (Long)RxInApps.this.storage.get(productType + RxInApps.LAST_LOAD);
                long delta = Utils.safe((Long)lastLoad) + RxInApps.this.cacheLifetime - System.currentTimeMillis();
                if (delta >= 0L && delta <= RxInApps.this.cacheLifetime && (map = (Map)RxInApps.this.storage.get(productType)) != null) {
                    return Single.just((Object)map);
                }
                return RxInApps.this.loadPurchasesByType(productType).compose(RxInApps.this.toMapAndCache(productType));
            }
        });
    }

    @NonNull
    SingleTransformer<List<Purchase>, Map<String, Purchase>> toMapAndCache(final String productType) {
        return new SingleTransformer<List<Purchase>, Map<String, Purchase>>(){

            public SingleSource<Map<String, Purchase>> apply(Single<List<Purchase>> upstream) {
                return upstream.flatMapObservable((Function)new Function<List<Purchase>, ObservableSource<Purchase>>(){

                    public ObservableSource<Purchase> apply(List<Purchase> purchases) throws Exception {
                        return Observable.fromIterable(purchases);
                    }
                }).toMap((Function)new Function<Purchase, String>(){

                    public String apply(Purchase purchase) throws Exception {
                        return purchase.getProductId();
                    }
                }).doOnSuccess((Consumer)new Consumer<Map<String, Purchase>>(){

                    public void accept(Map<String, Purchase> map) throws Exception {
                        RxInApps.this.storage.put(productType, map);
                        RxInApps.this.storage.put(productType + RxInApps.LAST_LOAD, System.currentTimeMillis());
                    }
                });
            }
        };
    }

    void putPurchaseToCache(Purchase purchase, String productType) {
        Map map = (Map)this.storage.get(productType);
        map.put(purchase.getProductId(), purchase);
        this.storage.put(productType, map);
    }

    void removePurchaseFromCache(String productId, String productType) {
        Map map = (Map)this.storage.get(productType);
        map.remove(productId);
        this.storage.put(productType, map);
    }

    boolean checkPurchaseSubscriber() {
        return RxUtils.isDisposed((SingleEmitter)Utils.unwrap(this.purchaseSubscriber));
    }

    private Single<Purchase> purchase(final String productId, final String productType) {
        return Single.defer((Callable)new Callable<SingleSource<? extends Purchase>>(){

            @Override
            public SingleSource<? extends Purchase> call() throws Exception {
                if (Utils.isEmpty((CharSequence)productId)) {
                    return Single.error((Throwable)new IllegalArgumentException("Product id can't be empty"));
                }
                return RxInApps.this.initialization().flatMap((Function)new Function<IInAppBillingService, SingleSource<? extends Purchase>>(){

                    public SingleSource<? extends Purchase> apply(IInAppBillingService billingService) throws Exception {
                        return Single.create((SingleOnSubscribe)PurchaseOnSubscribe.create(RxInApps.this, billingService, RxInApps.this.packageName, productId, productType, RxInApps.this.purchaseSubscriber));
                    }
                }).doOnDispose(new Action(){

                    public void run() throws Exception {
                        RxInApps.this.purchaseSubscriber.set(null);
                    }
                });
            }
        });
    }

    boolean bindPurchaseUnsubscribe(Cancellable cancellable) {
        return RxUtils.setOnDispose((SingleEmitter)Utils.unwrap(this.purchaseSubscriber), cancellable);
    }

    boolean deliverPurchaseResult(Purchase purchase) {
        return RxUtils.onSuccess((SingleEmitter)Utils.unwrap(this.purchaseSubscriber), purchase);
    }

    boolean deliverPurchaseError(Throwable th) {
        return RxUtils.onError((SingleEmitter)Utils.unwrap(this.purchaseSubscriber), th);
    }

    private Single<SkuDetails> getSkuDetails(String productId, String productType) {
        return this.getSkuDetails(Collections.singletonList(productId), productType).map((Function)new Function<List<SkuDetails>, SkuDetails>(){

            public SkuDetails apply(List<SkuDetails> skuDetails) throws Exception {
                return (SkuDetails)Utils.first(skuDetails);
            }
        });
    }

    private Single<List<SkuDetails>> getSkuDetails(final List<String> productIdList, final String productType) {
        return Single.defer((Callable)new Callable<SingleSource<? extends List<SkuDetails>>>(){

            @Override
            public SingleSource<? extends List<SkuDetails>> call() throws Exception {
                if (Utils.isEmpty((Collection)productIdList)) {
                    return Single.error((Throwable)new NullPointerException("Product id list can't be empty"));
                }
                return RxInApps.this.initialization().flatMap((Function)new Function<IInAppBillingService, SingleSource<List<SkuDetails>>>(){

                    public SingleSource<List<SkuDetails>> apply(IInAppBillingService billingService) throws Exception {
                        return Single.create((SingleOnSubscribe)new SkuDetailsOnSubscribe(billingService, RxInApps.this.packageName, RxInApps.this.parser, productIdList, productType));
                    }
                });
            }
        });
    }

    public Single<List<Purchase>> loadPurchasedProducts() {
        return this.loadPurchasesByType("inapp");
    }

    public Single<Map<String, Purchase>> purchasedProductsMap() {
        return this.purchasesByTypeMap("inapp");
    }

    public Single<List<Purchase>> purchasedProducts() {
        return this.purchasedProductsMap().map((Function)new Function<Map<String, Purchase>, List<Purchase>>(){

            public List<Purchase> apply(Map<String, Purchase> map) throws Exception {
                return new ArrayList<Purchase>(map.values());
            }
        });
    }

    public Single<List<String>> purchasedProductIds() {
        return this.purchasedProductsMap().map((Function)new Function<Map<String, Purchase>, List<String>>(){

            public List<String> apply(Map<String, Purchase> map) throws Exception {
                return new ArrayList<String>(map.keySet());
            }
        });
    }

    public Single<Boolean> isPurchased(final String productId) {
        return this.purchasedProductsMap().map((Function)new Function<Map<String, Purchase>, Boolean>(){

            public Boolean apply(Map<String, Purchase> map) throws Exception {
                return map.containsKey(productId);
            }
        });
    }

    public Single<Purchase> getPurchasedProduct(final String productId) {
        return this.purchasedProductsMap().map((Function)new Function<Map<String, Purchase>, Purchase>(){

            public Purchase apply(Map<String, Purchase> map) throws Exception {
                if (map.containsKey(productId)) {
                    return map.get(productId);
                }
                throw new ProductNotFoundException(String.format("Product \"%s\" not found!", productId));
            }
        });
    }

    public Single<Purchase> purchase(String productId) {
        return this.purchase(productId, "inapp");
    }

    public Single<Purchase> consume(final String productId) {
        return Single.defer((Callable)new Callable<SingleSource<? extends Purchase>>(){

            @Override
            public SingleSource<? extends Purchase> call() throws Exception {
                if (Utils.isEmpty((CharSequence)productId)) {
                    return Single.error((Throwable)new IllegalArgumentException("Product id can't be empty"));
                }
                return RxInApps.this.initialization().flatMap((Function)new Function<IInAppBillingService, SingleSource<Purchase>>(){

                    public SingleSource<Purchase> apply(final IInAppBillingService billingService) throws Exception {
                        return RxInApps.this.loadPurchasesByType(billingService, "inapp").compose(RxInApps.this.toMapAndCache("inapp")).flatMap((Function)new Function<Map<String, Purchase>, SingleSource<Purchase>>(){

                            public SingleSource<Purchase> apply(Map<String, Purchase> map) throws Exception {
                                return Single.create((SingleOnSubscribe)ConsumePurchaseOnSubscribe.create(RxInApps.this, billingService, RxInApps.this.packageName, map, productId));
                            }
                        });
                    }
                });
            }
        });
    }

    public Single<SkuDetails> getProduct(String productId) {
        return this.getSkuDetails(productId, "inapp");
    }

    public Single<List<SkuDetails>> getProducts(List<String> productIdList) {
        return this.getSkuDetails(productIdList, "inapp");
    }

    public Single<List<Purchase>> loadPurchasedSubscriptions() {
        return this.loadPurchasesByType("subs");
    }

    public Single<Map<String, Purchase>> purchasedSubscriptionsMap() {
        return this.purchasesByTypeMap("subs");
    }

    public Single<List<Purchase>> purchasedSubscriptions() {
        return this.purchasedSubscriptionsMap().map((Function)new Function<Map<String, Purchase>, List<Purchase>>(){

            public List<Purchase> apply(Map<String, Purchase> map) throws Exception {
                return new ArrayList<Purchase>(map.values());
            }
        });
    }

    public Single<List<String>> purchasedSubscriptionIds() {
        return this.purchasedSubscriptionsMap().map((Function)new Function<Map<String, Purchase>, List<String>>(){

            public List<String> apply(Map<String, Purchase> map) throws Exception {
                return new ArrayList<String>(map.keySet());
            }
        });
    }

    public Single<Boolean> isSubscribed(final String productId) {
        return this.purchasedSubscriptionsMap().map((Function)new Function<Map<String, Purchase>, Boolean>(){

            public Boolean apply(Map<String, Purchase> map) throws Exception {
                return map.containsKey(productId);
            }
        });
    }

    public Single<Purchase> getPurchasedSubscription(final String productId) {
        return this.purchasedSubscriptionsMap().map((Function)new Function<Map<String, Purchase>, Purchase>(){

            public Purchase apply(Map<String, Purchase> map) throws Exception {
                if (map.containsKey(productId)) {
                    return map.get(productId);
                }
                throw new ProductNotFoundException(String.format("Subscription \"%s\" not found!", productId));
            }
        });
    }

    public Single<Purchase> subscribe(String productId) {
        return this.purchase(productId, "subs");
    }

    public Single<SkuDetails> getSubscription(String productId) {
        return this.getSkuDetails(productId, "subs");
    }

    public Single<List<SkuDetails>> getSubscriptions(List<String> productIdList) {
        return this.getSkuDetails(productIdList, "subs");
    }

    public static class Builder {
        private Context context;
        private Parser parser;
        private String licenseKey;
        private String merchantId;
        private Long timeout;
        private Long cacheLifetime;
        private Storage storage;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        Context getContext() {
            return this.context;
        }

        Parser getParser() {
            if (this.parser == null) {
                return new GsonParser();
            }
            return this.parser;
        }

        Storage getStorage() {
            if (this.storage == null) {
                return new HawkStorage(this.context, this.parser);
            }
            return this.storage;
        }

        String getLicenseKey() {
            return this.licenseKey;
        }

        String getMerchantId() {
            return this.merchantId;
        }

        Long getTimeout() {
            if (this.timeout == null) {
                return TimeUnit.SECONDS.toMillis(30L);
            }
            return this.timeout;
        }

        Long getCacheLifetime() {
            if (this.cacheLifetime == null) {
                return TimeUnit.MINUTES.toMillis(30L);
            }
            return this.cacheLifetime;
        }

        public Builder parser(Parser parser) {
            this.parser = parser;
            return this;
        }

        public Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public Builder licenseKey(String licenseKey) {
            this.licenseKey = licenseKey;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder timeout(long value, TimeUnit timeUnit) {
            this.timeout = timeUnit.toMillis(value);
            return this;
        }

        public Builder cacheLifetime(long value, TimeUnit timeUnit) {
            this.cacheLifetime = timeUnit.toMillis(value);
            return this;
        }
    }
}

