/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import io.reactivex.SingleEmitter;
import io.reactivex.functions.Cancellable;

class RxUtils {
    private RxUtils() {
    }

    public static boolean isDisposed(SingleEmitter emitter) {
        return emitter == null || emitter.isDisposed();
    }

    public static <T> boolean setOnDispose(SingleEmitter<T> emitter, Cancellable cancellable) {
        if (emitter != null && !emitter.isDisposed()) {
            emitter.setCancellable(cancellable);
            return true;
        }
        return false;
    }

    public static <T> boolean onSuccess(SingleEmitter<T> emitter, T item) {
        if (emitter != null && !emitter.isDisposed()) {
            emitter.onSuccess(item);
            return true;
        }
        return false;
    }

    public static <T> boolean onError(SingleEmitter<T> emitter, Throwable th) {
        if (emitter != null && !emitter.isDisposed()) {
            emitter.onError(th);
            return true;
        }
        return false;
    }
}

