/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps;

import android.os.Bundle;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import xyz.truenight.rxinapps.RxInApps;
import xyz.truenight.rxinapps.exception.LoadFailedException;
import xyz.truenight.rxinapps.model.SkuDetails;
import xyz.truenight.rxinapps.util.Parser;
import xyz.truenight.utils.Utils;

class SkuDetailsOnSubscribe
implements SingleOnSubscribe<List<SkuDetails>> {
    private static final String TAG = RxInApps.TAG;
    private IInAppBillingService billingService;
    private String packageName;
    private Parser parser;
    private List<String> productIdList;
    private String productType;

    public SkuDetailsOnSubscribe(IInAppBillingService billingService, String packageName, Parser parser, List<String> productIdList, String productType) {
        this.billingService = billingService;
        this.packageName = packageName;
        this.parser = parser;
        this.productIdList = productIdList;
        this.productType = productType;
    }

    private static <T> ArrayList<T> toArrayList(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ArrayList) {
            return (ArrayList)list;
        }
        return new ArrayList<T>(list);
    }

    public void subscribe(SingleEmitter<List<SkuDetails>> emitter) throws Exception {
        try {
            List batches = Utils.chop(this.productIdList, (int)20);
            ArrayList<SkuDetails> skuDetails = new ArrayList<SkuDetails>();
            for (List batch : batches) {
                Bundle products = new Bundle();
                products.putStringArrayList("ITEM_ID_LIST", SkuDetailsOnSubscribe.toArrayList(batch));
                Bundle skuBundle = this.billingService.getSkuDetails(3, this.packageName, this.productType, products);
                int response = skuBundle.getInt("RESPONSE_CODE");
                if (response == 0) {
                    ArrayList detailsList = skuBundle.getStringArrayList("DETAILS_LIST");
                    if (detailsList == null) continue;
                    for (String responseLine : detailsList) {
                        SkuDetails product = (SkuDetails)this.parser.fromString(responseLine, (Type)((Object)SkuDetails.class));
                        skuDetails.add(product);
                    }
                    continue;
                }
                throw new LoadFailedException("Failed to get sku details: RESPONSE_CODE=" + response);
            }
            emitter.onSuccess(skuDetails);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to call getSkuDetails", (Throwable)e);
            emitter.onError((Throwable)e);
        }
    }
}

