/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps.hawk;

import android.content.Context;
import android.content.SharedPreferences;
import com.orhanobut.hawk.Storage;

public final class SharedPreferencesStorage
implements Storage {
    private final SharedPreferences preferences;

    public SharedPreferencesStorage(Context context, String tag) {
        this.preferences = context.getSharedPreferences(tag, 0);
    }

    public SharedPreferencesStorage(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    public <T> boolean put(String key, T value) {
        SharedPreferencesStorage.checkNull("key", key);
        return this.getEditor().putString(key, String.valueOf(value)).commit();
    }

    public <T> T get(String key) {
        return (T)this.preferences.getString(key, null);
    }

    public boolean delete(String key) {
        return this.getEditor().remove(key).commit();
    }

    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    public boolean deleteAll() {
        return this.getEditor().clear().commit();
    }

    public long count() {
        return this.preferences.getAll().size();
    }

    private SharedPreferences.Editor getEditor() {
        return this.preferences.edit();
    }

    private static void checkNull(String message, Object value) {
        if (value == null) {
            throw new NullPointerException(message + " should not be null");
        }
    }
}

