/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.rxinapps.model;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Currency;
import xyz.truenight.rxinapps.model.ProductType;
import xyz.truenight.utils.Utils;

public class SkuDetails {
    public static final String FIELD_PRODUCT_ID = "productId";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_PRICE_CURRENCY_CODE = "price_currency_code";
    public static final String FIELD_PRICE_AMOUNT_MICROS = "price_amount_micros";
    public static final String FIELD_PRICE = "price";
    private static final BigDecimal MILLION = BigDecimal.valueOf(1000000L);
    @SerializedName(value="productId")
    private String productId;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="price_currency_code")
    private String currency;
    @SerializedName(value="price_amount_micros")
    private BigDecimal priceValueMicros;
    @SerializedName(value="price")
    private String priceText;

    public boolean isSubscription() {
        return ProductType.isSubscription(this.type);
    }

    public String getProductId() {
        return this.productId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getPriceValue() {
        return this.priceValueMicros.divide(MILLION, RoundingMode.HALF_UP);
    }

    public String getLocalizedPrice() {
        if (Utils.equal((Object)this.currency, (Object)"RUB")) {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            formatter.setMinimumFractionDigits(0);
            formatter.setMaximumFractionDigits(2);
            return formatter.format(this.getPriceValue()) + " \u20bd";
        }
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        formatter.setCurrency(Currency.getInstance(this.currency));
        return formatter.format(this.getPriceValue());
    }

    BigDecimal getPriceValueMicros() {
        return this.priceValueMicros;
    }

    public String getPriceText() {
        return this.priceText;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkuDetails that = (SkuDetails)o;
        return this.isSubscription() == that.isSubscription() && !(this.productId == null ? that.productId != null : !this.productId.equals(that.productId));
    }

    public int hashCode() {
        int result = this.productId != null ? this.productId.hashCode() : 0;
        result = 31 * result + (this.isSubscription() ? 1 : 0);
        return result;
    }
}

