/*
 * Copyright (c) 2021 , Inc. All Rights Reserved.
 */

package xyz.xiamang.holiday.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.goterl.resourceloader.FileLoader;

/**
 *
 * @author ysq
 */
public class ResourceUtils {

    //一共5个类加载器
    static ClassLoader[] getClassLoaders(ClassLoader classLoader) {
        return new ClassLoader[] {
                classLoader,
                // defaultClassLoader,
                Thread.currentThread().getContextClassLoader(),
                ClassLoader.getSystemClassLoader(),
                ResourceUtils.class.getClassLoader()
        };
    }

    public static List<URL> readResourcesFromFolder(ClassLoader loader, String path) throws IOException {
        ClassLoader[] loaders = getClassLoaders(loader);
        for (ClassLoader c : loaders) {
            List<URL> list = getResources(c, path);
            System.out.println("loader:" + c + ":" + list);
            if (list != null) {
                return list;
            }
        }
        return null;
    }

    public static List<URL> getResources2(ClassLoader loader, String path) throws IOException {
        try {
            InputStream is = loader.getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            List<String> lines = br.lines().collect(Collectors.toList());
            System.out.println("l:" + lines);
        } catch (Exception e) {
            //return br.lines();
            return null;
        }
        return null;
    }

    public static List<URL> getResources(ClassLoader loader, String path) throws IOException {
        try {
            InputStream is = loader.getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);

            return br.lines()
                    .map(l -> path + "/" + l)
                    .map(r -> loader.getResource(r))
                    .collect(Collectors.toList());
        } catch (Exception e) {
            throw e;
        }
    }

    public static List<URL> getResources(final String path) throws IOException {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (
                final InputStream is = loader.getResourceAsStream(path);
                final InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                final BufferedReader br = new BufferedReader(isr)) {

            return br.lines()
                    .map(l -> path + "/" + l)
                    .map(r -> loader.getResource(r))
                    .collect(Collectors.toList());
        }
    }

    public static List<File> getResourcesFile(final String path) throws IOException {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (
                InputStream is = loader.getResourceAsStream(path);
                final InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                final BufferedReader br = new BufferedReader(isr)) {
            return br.lines()
                    .map(l -> path + "/" + l)
                    .map(r -> loader.getResource(r))
                    .map(r -> new File(r.getFile()))
                    .collect(Collectors.toList());
        }
    }

//    public static List<File> getResourcesFile2(Class clazz, String path) throws IOException {
//        ClassLoader[] loaders = getClassLoaders(clazz.getClassLoader());
//        for (ClassLoader c : loaders) {
//            List<File> files = getResourcesFile2(c, path);
//            if (files == null || files.size() == 0) {
//                continue;
//            }
//            return files;
//        }
//        return null;
//    }

    public static List<File> readResourceDir(Class clazz, String path) throws Exception {
        try {
            File dir = FileLoader.get().load(path, clazz);
            if (dir == null) {
                return null;
            }
            return new ArrayList<File>(Arrays.asList(dir.listFiles()));
        } catch (Exception e) {
            throw e;
        }
    }

    public static List<File> readCustomResourcesFile(ClassLoader loader, String path) throws IOException {
        System.out.println("####:" + loader + "   p:" + path);
        try {
            InputStream is = loader.getResourceAsStream(path);
            if (is == null) {
                return null;
            }

            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);

            List<String> lines = br.lines().collect(Collectors.toList());
            System.out.println("l:" + lines);
            List<File> list = new ArrayList<>();
            for (String l : lines) {
                URL url = loader.getResource(path + "/" + l);
                if (url == null)
                    return null;
                File f = new File(url.getFile());
                //                System.out.println("url:" + url);
                //                System.out.println("f:" + f);
                list.add(f);
            }
            return list;
        } catch (Exception e) {
            throw e;
        }
    }
}
