/*
 * Decompiled with CFR 0.152.
 */
package xyz.xiamang.holiday.config;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.xiamang.holiday.config.JsonConfig;
import xyz.xiamang.holiday.util.JsonUtils;

public class JsonConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(JsonConfigLoader.class);

    private static String loadAsString(File file) throws FileNotFoundException {
        return JsonConfigLoader.loadAsString(new FileInputStream(file));
    }

    private static String loadAsString(String configFileName) {
        InputStream in = JsonConfigLoader.class.getResourceAsStream(configFileName);
        return JsonConfigLoader.loadAsString(in);
    }

    private static String loadAsString(InputStream in) {
        byte[] bytes = new byte[]{};
        try {
            bytes = new byte[in.available()];
            in.read(bytes);
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d \u914d\u7f6e\u5931\u8d25 {} {}", (Throwable)e);
            e.printStackTrace();
        }
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public static <T extends JsonConfig> Map<String, T> loadAndToMap(String configFileName, Class<T> clazz, String keyField) {
        List<T> list = JsonConfigLoader.loadList(configFileName, clazz);
        HashMap map = new HashMap();
        list.stream().forEach(l -> {
            Object k = l.get(keyField);
            map.put((String)k, l);
            log.info("\u914d\u7f6e {} {}", k, l);
        });
        log.info("\u52a0\u8f7d\u914d\u7f6e {} \u6210\u529f \u5171 {}\u9879", (Object)configFileName, (Object)map.size());
        return map;
    }

    public static <T> T load(String configFileName, Class<T> clazz) {
        String s = JsonConfigLoader.loadAsString(configFileName);
        return JsonUtils.deserialize(s, clazz);
    }

    public static <T> T load(File file, Class<T> clazz) {
        String s;
        long s1 = System.currentTimeMillis();
        try {
            s = JsonConfigLoader.loadAsString(file);
            long s2 = System.currentTimeMillis();
            log.debug("load cost {}", (Object)(s2 - s1));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        T t = JsonUtils.deserialize(s, clazz);
        long s3 = System.currentTimeMillis();
        log.debug("load parse cost {}", (Object)(s3 - s1));
        return t;
    }

    public static <T> List<T> loadList(String configFileName, Class<T> clazz) {
        String s = JsonConfigLoader.loadAsString(configFileName);
        log.debug("json config {} -{}", (Object)configFileName, (Object)s);
        return (List)JsonUtils.deserialize(s, new TypeReference<List<T>>(){});
    }
}

