/*
 * Decompiled with CFR 0.152.
 */
package xyz.xiamang.holiday.service;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.xiamang.holiday.config.JsonConfigLoader;
import xyz.xiamang.holiday.dto.DayDetail;
import xyz.xiamang.holiday.dto.DayType;
import xyz.xiamang.holiday.exception.UnSupportException;
import xyz.xiamang.holiday.util.ResourceUtils;
import xyz.xiamang.holiday.util.StringUtils;

public class HolidayService {
    private static final Map<String, DayDetail> DAY_DETAIL_CACHE = new LinkedHashMap<String, DayDetail>(4096);
    private static final Map<String, DayDetail> HOLIDAY_CONFIG = new HashMap<String, DayDetail>(512);
    private static final String[] WEEK_NAMES = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static final Integer[] WEEK_INDEX = new Integer[]{7, 1, 2, 3, 4, 5, 6};
    private static String MAX_YEAR = "2021";
    private static String MAX_DAY = "2024-12-31";
    private static String CONFIG_DEFAULT_DIR = "_CONFIG_HOlIDAY";
    private static String CONFIG_CUSTOM_DIR = "";
    private static final Logger logger = LoggerFactory.getLogger(HolidayService.class);

    public HolidayService() {
        this.init();
    }

    public HolidayService(String customConfigPath) {
        CONFIG_CUSTOM_DIR = customConfigPath;
        this.init();
    }

    private void init() {
        this.loadFromJsonConfig();
    }

    private List<File> loadConfig() {
        try {
            System.out.println("#######" + CONFIG_CUSTOM_DIR);
            String configPath = StringUtils.isBlank(CONFIG_CUSTOM_DIR) ? CONFIG_DEFAULT_DIR : CONFIG_CUSTOM_DIR;
            List<File> fs = null;
            fs = StringUtils.isBlank(CONFIG_CUSTOM_DIR) ? ResourceUtils.readResourceDir(this.getClass(), CONFIG_DEFAULT_DIR) : ResourceUtils.readCustomResourcesFile(this.getClass().getClassLoader(), CONFIG_CUSTOM_DIR);
            Collections.sort(fs, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            return fs;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25! {}", (Throwable)e);
            e.printStackTrace();
            throw new UnSupportException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25! load holiday config failed!");
        }
    }

    private void loadFromJsonConfig() {
        long start = System.currentTimeMillis();
        List<File> fs = this.loadConfig();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File f : fs) {
            logger.debug("{}", (Object)f.getName());
            if (!f.getName().contains("json")) {
                logger.warn("{} \u4e0d\u5305\u542b\u8282\u5047\u65e5\u914d\u7f6e\u5ffd\u7565", (Object)f.getName());
                continue;
            }
            fileNames.add(f.getName());
            MAX_YEAR = f.getName().substring(0, 4);
            Map map = JsonConfigLoader.load(f, Map.class);
            this.parseConfig(map);
        }
        long e1 = System.currentTimeMillis();
        logger.debug("cost1 {}", (Object)(e1 - start));
        this.initAllDay();
        long end = System.currentTimeMillis();
        System.out.println("##### holiday config files " + fileNames);
        logger.info("#### \u8282\u5047\u65e5\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210 \u8017\u65f6\uff1a{}ms\uff0c\u6700\u5927\u65e5\u671f\uff1a{}\uff0c\u5171{}\u4e2a\u65e5\u671f\uff0c\u914d\u7f6e\u6587\u4ef6\uff1a{}", new Object[]{end - start, MAX_DAY, DAY_DETAIL_CACHE.size(), fileNames});
    }

    private void parseConfig(Map map) {
        Map m2 = (Map)map.get("holiday");
        m2.values().forEach(m -> {
            DayDetail day = new DayDetail();
            String d = (String)m.get("date");
            day.setDay(d);
            day.setDayAlias(d.replace("-", ""));
            day.setName((String)m.get("name"));
            day.setWage((Integer)m.get("wage"));
            Boolean f = (Boolean)m.get("holiday");
            day.setHoliday(f);
            day.setDayType(f != false ? DayType.HOLIDAY : DayType.TRADEDAY);
            day.setHolidayName((String)m.get("target"));
            HOLIDAY_CONFIG.put(day.getDayAlias(), day);
        });
    }

    private void initAllDay() {
        Calendar calendar = Calendar.getInstance();
        int maxYear = Integer.valueOf(MAX_YEAR);
        calendar.set(2013, 0, 1);
        int y = 0;
        DayDetail maxDay = null;
        while (y <= maxYear) {
            maxDay = this.queryDayDetailAndPutCache(calendar);
            calendar.add(5, 1);
            y = calendar.get(1);
        }
        MAX_DAY = maxDay.getDayAlias();
    }

    public boolean isHoliday() {
        return this.isHoliday(new Date());
    }

    public boolean isHoliday(Date day) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String key = sdf.format(day);
        return this.isHoliday(key);
    }

    public boolean isHoliday(String day) {
        if (StringUtils.isBlank(day) || !day.startsWith("2") || day.length() != 8 && day.length() != 10) {
            String msg = "\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u652f\u6301\u7684\u683c\u5f0f\uff1ayyyy-mm-dd\u6216yyyymmdd\uff0c\u793a\u4f8b2021-09-09\u621620210909\uff0c\u5b9e\u9645\u53c2\u6570:" + day;
            throw new UnSupportException(msg);
        }
        DayDetail detail = this.queryDayDetail(day);
        if (detail == null) {
            String msg = "\u4ec5\u652f\u6301 2013-01-01\u81f3" + MAX_DAY + " \u671f\u95f4\u8282\u5047\u65e5\u67e5\u8be2\uff0c\u8bf7\u66f4\u65b0\u81f3\u6700\u65b0\u7248\u672c https://mvnrepository.com/artifact/xyz.xiamang/holiday \uff0c\u6216\u5728src/main/resources/holiday/\u6587\u4ef6\u5939\u4e2d\u8fdb\u884c\u914d\u7f6e";
            throw new UnSupportException(msg);
        }
        return detail.isHoliday();
    }

    public DayDetail queryDayDetail(String day) {
        String key = this.dayKey(day);
        return DAY_DETAIL_CACHE.get(key);
    }

    public List<DayDetail> queryDayByType(DayType type, String startDay, String endDay) {
        String startKey = this.dayKey(startDay);
        String endKey = this.dayKey(endDay);
        List<DayDetail> result = DAY_DETAIL_CACHE.entrySet().stream().filter(e -> {
            Boolean f = false;
            String key = (String)e.getKey();
            DayDetail value = (DayDetail)e.getValue();
            f = type.equals((Object)DayType.ALL_WORKDAY) ? Boolean.valueOf(DayType.WORKDAY.equals((Object)value.getDayType()) || DayType.TRADEDAY.equals((Object)value.getDayType())) : (type.equals((Object)DayType.ALL_NO_WORKDAY) ? Boolean.valueOf(DayType.HOLIDAY.equals((Object)value.getDayType()) || DayType.WEEKEND.equals((Object)value.getDayType())) : Boolean.valueOf(type.equals((Object)value.getDayType())));
            return f != false && key.compareTo(startKey) >= 0 && key.compareTo(endKey) <= 0;
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        return result;
    }

    public DayDetail nextDayByType(DayType type, String startDay) {
        String startKey = this.dayKey(startDay);
        for (Map.Entry<String, DayDetail> entry : DAY_DETAIL_CACHE.entrySet()) {
            String key = entry.getKey();
            if (key.compareTo(startKey) <= 0) continue;
            Boolean f = false;
            DayDetail value = entry.getValue();
            f = type.equals((Object)DayType.ALL_WORKDAY) ? Boolean.valueOf(DayType.WORKDAY.equals((Object)value.getDayType()) || DayType.TRADEDAY.equals((Object)value.getDayType())) : (type.equals((Object)DayType.ALL_NO_WORKDAY) ? Boolean.valueOf(DayType.HOLIDAY.equals((Object)value.getDayType()) || DayType.WEEKEND.equals((Object)value.getDayType())) : Boolean.valueOf(type.equals((Object)value.getDayType())));
            if (!f.booleanValue()) continue;
            return value;
        }
        return null;
    }

    public DayDetail queryDayDetailAndPutCache(Calendar calendar) {
        String key = this.dayKey(calendar);
        int w = calendar.get(7);
        DayDetail detail = HOLIDAY_CONFIG.get(key);
        if (detail == null) {
            detail = new DayDetail();
            detail.setWage(1);
            detail.setDay(key.substring(0, 4) + "-" + key.substring(4, 6) + "-" + key.substring(6));
            detail.setDayAlias(key);
            if (1 == w || 7 == w) {
                detail.setDayType(DayType.WEEKEND);
                detail.setHoliday(true);
            } else {
                detail.setDayType(DayType.WORKDAY);
                detail.setHoliday(false);
            }
            detail.setName(key);
            detail.setName(WEEK_NAMES[w - 1]);
        }
        detail.setDayOfWeek(WEEK_INDEX[w - 1]);
        DAY_DETAIL_CACHE.put(key, detail);
        return detail;
    }

    private String dayKey(String day) {
        return day.replace("-", "");
    }

    private String dayKey(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2) + 1;
        int d = calendar.get(5);
        return y + (m < 10 ? "0" + m : "" + m) + (d < 10 ? "0" + d : "" + d);
    }
}

