/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

public class ClassLoaderUtils {
    private static ClassLoader elect0(ClassLoader candidate) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader == null) {
            return candidate;
        }
        if (ClassLoaderUtils.isChild(contextLoader, candidate)) {
            return candidate;
        }
        if (ClassLoaderUtils.isChild(candidate, contextLoader)) {
            return contextLoader;
        }
        return contextLoader;
    }

    public static ClassLoader guessClassLoader(ClassLoader candidate) {
        ClassLoader systemLoader;
        ClassLoader candidate0 = ClassLoaderUtils.elect0(candidate);
        if (ClassLoaderUtils.isChild(candidate0, systemLoader = ClassLoader.getSystemClassLoader())) {
            return systemLoader;
        }
        return candidate0;
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == loader2) {
            return true;
        }
        if (loader2 == null) {
            return false;
        }
        if (loader1 == null) {
            return true;
        }
        while (loader2 != null) {
            if (loader2 == loader1) {
                return true;
            }
            loader2 = loader2.getParent();
        }
        return false;
    }
}

