/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

public final class IntArray {
    private int[] buf;
    private int len = 0;

    public int[] toArray() {
        int[] ret = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            ret[i] = this.buf[i];
        }
        return ret;
    }

    public IntArray(int capacity) {
        this.buf = new int[capacity];
    }

    public IntArray() {
        this(10);
    }

    public int size() {
        return this.len;
    }

    private void checkIndex(int i) {
        if (i < 0 || i >= this.len) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
    }

    public int get(int i) {
        this.checkIndex(i);
        return this.buf[i];
    }

    public int set(int i, int val) {
        this.checkIndex(i);
        int old = this.buf[i];
        this.buf[i] = val;
        return old;
    }

    private static int calcSize(int l, int factor) {
        int rem = l % factor;
        return l / factor * factor + (rem > 0 ? factor : 0);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.buf.length) {
            int factor = this.buf.length / 2 + 1;
            this.grow(IntArray.calcSize(capacity - this.buf.length, factor));
        }
    }

    private void grow(int l) {
        int[] nbuf = new int[this.buf.length + l];
        for (int i = 0; i < this.buf.length; ++i) {
            nbuf[i] = this.buf[i];
        }
        this.buf = nbuf;
    }

    public IntArray add(int i) {
        this.ensureCapacity(this.len + 1);
        this.buf[this.len++] = i;
        return this;
    }
}

