/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;

public class SerializableMethod
implements Serializable {
    private transient Method mtd;

    public SerializableMethod(Method mtd) {
        this.mtd = mtd;
    }

    public Method getMethod() {
        return this.mtd;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.mtd.getDeclaringClass());
        out.writeObject(this.mtd.getName());
        out.writeObject(this.mtd.getParameterTypes());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class c = (Class)in.readObject();
            String name = (String)in.readObject();
            Class[] ptypes = (Class[])in.readObject();
            this.mtd = c.getDeclaredMethod(name, ptypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializableMethod) {
            SerializableMethod other = (SerializableMethod)obj;
            return this.mtd.equals(other.mtd);
        }
        return false;
    }

    public int hashCode() {
        return this.mtd.hashCode();
    }

    public String toString() {
        return this.mtd.toString();
    }
}

