/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.parsing.utils;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import za.co.absa.abris.avro.read.confluent.SchemaManager$;
import za.co.absa.abris.avro.schemas.SchemaLoader$;

public final class AvroSchemaUtils$ {
    public static AvroSchemaUtils$ MODULE$;
    private final Logger logger;

    static {
        new AvroSchemaUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    private void configureSchemaManager(Map<String, String> schemaRegistryConf) {
        block0: {
            if (SchemaManager$.MODULE$.isSchemaRegistryConfigured()) break block0;
            SchemaManager$.MODULE$.configureSchemaRegistry(schemaRegistryConf);
        }
    }

    public Schema parse(String schema) {
        return new Schema.Parser().parse(schema);
    }

    public Schema load(String path) {
        return this.parse(this.loadPlain(path));
    }

    public Schema loadForValue(Map<String, String> schemaRegistryConf) {
        return SchemaLoader$.MODULE$.loadFromSchemaRegistryValue(schemaRegistryConf);
    }

    public Schema loadForKey(Map<String, String> schemaRegistryConf) {
        return SchemaLoader$.MODULE$.loadFromSchemaRegistryKey(schemaRegistryConf);
    }

    public SchemaMetadata load(int schemaVersion, Map<String, String> schemaRegistryConf) {
        return SchemaLoader$.MODULE$.loadFromSchemaRegistry(schemaVersion, schemaRegistryConf);
    }

    public Option<Object> registerIfCompatibleKeySchema(String topic, Schema schema, Map<String, String> schemaRegistryConf) {
        return this.registerIfCompatibleSchema(topic, schema, schemaRegistryConf, true);
    }

    public Option<Object> registerIfCompatibleValueSchema(String topic, Schema schema, Map<String, String> schemaRegistryConf) {
        return this.registerIfCompatibleSchema(topic, schema, schemaRegistryConf, false);
    }

    private Option<Object> registerIfCompatibleSchema(String topic, Schema schema, Map<String, String> schemaRegistryConf, boolean isKey) {
        None$ none$;
        this.configureSchemaManager(schemaRegistryConf);
        Option<String> option = SchemaManager$.MODULE$.getSubjectName(topic, isKey, schema, schemaRegistryConf);
        if (option instanceof Some) {
            None$ none$2;
            Some some = (Some)option;
            String subject = (String)some.value();
            if (!SchemaManager$.MODULE$.exists(subject) || SchemaManager$.MODULE$.isCompatible(schema, subject)) {
                this.logger().info(new StringBuilder(76).append("AvroSchemaUtils.registerIfCompatibleSchema: Registering schema for subject: ").append(subject).toString());
                none$2 = SchemaManager$.MODULE$.register(schema, subject);
            } else {
                this.logger().error(new StringBuilder(65).append("Schema incompatible with latest for subject '").append(subject).append("' in Schema Registry").toString());
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public String loadPlain(String path) {
        return SchemaLoader$.MODULE$.loadFromFile(path);
    }

    private AvroSchemaUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

