/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.examples;

import java.util.Properties;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamReader;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.SymbolLiteral;
import za.co.absa.abris.avro.functions$;
import za.co.absa.abris.examples.utils.ExamplesUtils$;

public final class KafkaAvroReader$ {
    public static KafkaAvroReader$ MODULE$;
    private final String PARAM_JOB_NAME;
    private final String PARAM_JOB_MASTER;
    private final String PARAM_PAYLOAD_AVRO_SCHEMA;
    private final String PARAM_LOG_LEVEL;
    private final String PARAM_OPTION_SUBSCRIBE;
    private final String PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY;

    static {
        new KafkaAvroReader$();
    }

    private String PARAM_JOB_NAME() {
        return this.PARAM_JOB_NAME;
    }

    private String PARAM_JOB_MASTER() {
        return this.PARAM_JOB_MASTER;
    }

    private String PARAM_PAYLOAD_AVRO_SCHEMA() {
        return this.PARAM_PAYLOAD_AVRO_SCHEMA;
    }

    private String PARAM_LOG_LEVEL() {
        return this.PARAM_LOG_LEVEL;
    }

    private String PARAM_OPTION_SUBSCRIBE() {
        return this.PARAM_OPTION_SUBSCRIBE;
    }

    private String PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY() {
        return this.PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY;
    }

    public void main(String[] args) {
        ExamplesUtils$.MODULE$.checkArgs(args);
        Properties properties = ExamplesUtils$.MODULE$.loadProperties(args);
        SparkSession spark = ExamplesUtils$.MODULE$.getSparkSession(properties, this.PARAM_JOB_NAME(), this.PARAM_JOB_MASTER(), this.PARAM_LOG_LEVEL());
        DataStreamReader stream = ExamplesUtils$.MODULE$.ReaderStreamOptions(spark.readStream().format("kafka")).addOptions(properties);
        Dataset<Row> deserialized = this.configureExample((Dataset<Row>)stream.load(), properties);
        deserialized.printSchema();
        deserialized.writeStream().format("console").option("truncate", "false").start().awaitTermination();
    }

    private Dataset<Row> configureExample(Dataset<Row> dataFrame, Properties props) {
        Dataset dataset;
        if (new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY()))).toBoolean()) {
            Map<String, String> schemaRegistryConfig = ExamplesUtils$.MODULE$.SchemaRegistryConfiguration(props).getSchemaRegistryConfigurations(this.PARAM_OPTION_SUBSCRIBE());
            dataset = dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_avro(org.apache.spark.sql.functions$.MODULE$.col("value"), schemaRegistryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "data"))})).select("data.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        } else {
            String string;
            try (BufferedSource source = Source$.MODULE$.fromFile(props.getProperty(this.PARAM_PAYLOAD_AVRO_SCHEMA()), Codec$.MODULE$.fallbackSystemCodec());){
                string = source.mkString();
            }
            String schemaString = string;
            dataset = dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_avro(org.apache.spark.sql.functions$.MODULE$.col("value"), schemaString).as((Symbol)SymbolLiteral.bootstrap("apply", "data"))})).select("data.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        }
        return dataset;
    }

    private KafkaAvroReader$() {
        MODULE$ = this;
        this.PARAM_JOB_NAME = "job.name";
        this.PARAM_JOB_MASTER = "job.master";
        this.PARAM_PAYLOAD_AVRO_SCHEMA = "payload.avro.schema";
        this.PARAM_LOG_LEVEL = "log.level";
        this.PARAM_OPTION_SUBSCRIBE = "option.subscribe";
        this.PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY = "example.should.use.schema.registry";
    }
}

