/*
 * Copyright 2018 ABSA Group Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package za.co.absa.cobrix.cobol.parser.encoding.codepage

object EbcdicNonPrintable {
  val clf = '\r'
  val ccr = '\n'
  val spc = ' '
  val qts = '\''
  val qtd = '\"'
  val bsh = '\\'

  val del = '\u007f'
  val shy = '\u00ad'
  val nel = '\u0085'
  val rsp = '\u00a0'

  val c00 = '\u0000'
  val c01 = '\u0001'
  val c02 = '\u0002'
  val c03 = '\u0003'
  val c04 = '\u0004'
  val c05 = '\u0005'
  val c06 = '\u0006'
  val c07 = '\u0007'
  val c08 = '\u0008'
  val c09 = '\u0009'
  val c0b = '\u000b'
  val c0c = '\u000c'
  val c0e = '\u000e'
  val c0f = '\u000f'
  val c10 = '\u0010'
  val c11 = '\u0011'
  val c12 = '\u0012'
  val c13 = '\u0013'
  val c14 = '\u0014'
  val c15 = '\u0015'
  val c16 = '\u0016'
  val c17 = '\u0017'
  val c18 = '\u0018'
  val c19 = '\u0019'
  val c1a = '\u001a'
  val c1b = '\u001b'
  val c1c = '\u001c'
  val c1d = '\u001d'
  val c1e = '\u001e'
  val c1f = '\u001f'
}
