/*
 * Copyright 2018 ABSA Group Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package za.co.absa.cobrix.spark.cobol.builder

import org.apache.spark.sql.SparkSession
import za.co.absa.cobrix.spark.cobol.utils.HDFSUtils

class SparkCobolBuilder {
  def copybookContents(copybookContent: String)(implicit spark: SparkSession): SparkCobolOptionsBuilder = {
    new SparkCobolOptionsBuilder(copybookContent)
  }

  def copybookPath(copybookPath: String)(implicit spark: SparkSession): SparkCobolOptionsBuilder = {
    val copybook = HDFSUtils.loadTextFileFromHadoop(spark.sparkContext.hadoopConfiguration, copybookPath)
    new SparkCobolOptionsBuilder(copybook)
  }
}
