/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.spark.hats.transformations;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;
import za.co.absa.spark.hats.transformations.ArrayContext;
import za.co.absa.spark.hats.transformations.ArrayContext$;
import za.co.absa.spark.hats.utils.SchemaUtils$;
import za.co.absa.spark.hofs.package$;

public final class NestedArrayTransformations$ {
    public static NestedArrayTransformations$ MODULE$;

    static {
        new NestedArrayTransformations$();
    }

    public Dataset<Row> nestedWithColumnMap(Dataset<Row> df, String inputColumnName, String outputColumnName, Function1<Column, Column> expression) {
        return (Dataset)this.nestedWithColumnMapHelper(df, inputColumnName, outputColumnName, (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(this.toExtendedTransformation(expression)), this.nestedWithColumnMapHelper$default$5())._1();
    }

    public Dataset<Row> nestedWithColumnAndErrorMap(Dataset<Row> df, String inputColumnName, String outputColumnName, String errorColumnName, Function1<Column, Column> expression, Function1<Column, Column> errorCondition) {
        Dataset dataset;
        String deepErrorColumn;
        block3: {
            Tuple2<Dataset<Row>, String> tuple2;
            block2: {
                this.validateErrorColumnName(errorColumnName);
                tuple2 = this.nestedWithColumnMapHelper(df, inputColumnName, outputColumnName, (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(this.toExtendedTransformation(expression)), (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(this.toExtendedTransformation(errorCondition)));
                if (tuple2 == null) break block2;
                Dataset dfOut = (Dataset)tuple2._1();
                deepErrorColumn = (String)tuple2._2();
                if (dfOut == null) break block2;
                dataset = dfOut;
                if (deepErrorColumn != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        String string = deepErrorColumn;
        Tuple2 tuple2 = new Tuple2((Object)dataset, (Object)string);
        Tuple2 tuple22 = tuple2;
        Dataset dfOut = (Dataset)tuple22._1();
        String deepErrorColumn2 = (String)tuple22._2();
        return this.gatherErrors((Dataset<Row>)dfOut, deepErrorColumn2, errorColumnName);
    }

    public Dataset<Row> nestedExtendedWithColumnAndErrorMap(Dataset<Row> df, String inputColumnName, String outputColumnName, String errorColumnName, Function2<Column, Function1<String, Column>, Column> expression, Function2<Column, Function1<String, Column>, Column> errorCondition) {
        Dataset dataset;
        String deepErrorColumn;
        block3: {
            Tuple2<Dataset<Row>, String> tuple2;
            block2: {
                this.validateErrorColumnName(errorColumnName);
                tuple2 = this.nestedWithColumnMapHelper(df, inputColumnName, outputColumnName, (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(expression), (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(errorCondition));
                if (tuple2 == null) break block2;
                Dataset dfOut = (Dataset)tuple2._1();
                deepErrorColumn = (String)tuple2._2();
                if (dfOut == null) break block2;
                dataset = dfOut;
                if (deepErrorColumn != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        String string = deepErrorColumn;
        Tuple2 tuple2 = new Tuple2((Object)dataset, (Object)string);
        Tuple2 tuple22 = tuple2;
        Dataset dfOut = (Dataset)tuple22._1();
        String deepErrorColumn2 = (String)tuple22._2();
        return this.gatherErrors((Dataset<Row>)dfOut, deepErrorColumn2, errorColumnName);
    }

    public Dataset<Row> nestedStructMap(Dataset<Row> df, String inputStructField, String outputChildField, Function1<Column, Column> expression) {
        String updatedStructField = this.toStructNotation(inputStructField);
        return this.nestedWithColumnMap(df, updatedStructField, outputChildField, expression);
    }

    public Dataset<Row> nestedExtendedStructMap(Dataset<Row> df, String inputStructField, String outputChildField, Function2<Column, Function1<String, Column>, Column> expression) {
        String updatedStructField = this.toStructNotation(inputStructField);
        return (Dataset)this.nestedWithColumnMapHelper(df, updatedStructField, outputChildField, (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(expression), this.nestedWithColumnMapHelper$default$5())._1();
    }

    public Dataset<Row> nestedStructAndErrorMap(Dataset<Row> df, String inputStructField, String outputChildField, String errorColumnName, Function1<Column, Column> expression, Function1<Column, Column> errorCondition) {
        String updatedStructField = this.toStructNotation(inputStructField);
        return this.nestedWithColumnAndErrorMap(df, updatedStructField, outputChildField, errorColumnName, expression, errorCondition);
    }

    public Dataset<Row> nestedExtendedStructAndErrorMap(Dataset<Row> df, String inputStructField, String outputChildField, String errorColumnName, Function2<Column, Function1<String, Column>, Column> expression, Function2<Column, Function1<String, Column>, Column> errorCondition) {
        String updatedStructField = this.toStructNotation(inputStructField);
        return this.nestedExtendedWithColumnAndErrorMap(df, updatedStructField, outputChildField, errorColumnName, expression, errorCondition);
    }

    public Dataset<Row> nestedAddColumn(Dataset<Row> df, String newColumnName, Column expression) {
        Dataset dataset;
        try {
            dataset = (Dataset)this.nestedWithColumnMapHelper(df, newColumnName, "", (Option<Function2<Column, Function1<String, Column>, Column>>)new Some((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> expression), (Option<Function2<Column, Function1<String, Column>, Column>>)None$.MODULE$)._1();
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().contains("Output field cannot be empty")) {
                throw new IllegalArgumentException(new StringBuilder(29).append("The column '").append(newColumnName).append("' already exists.").toString(), illegalArgumentException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw e;
            }
            throw throwable;
        }
        return dataset;
    }

    public Dataset<Row> nestedAddColumnExtended(Dataset<Row> df, String newColumnName, Function2<Column, Function1<String, Column>, Column> expression) {
        Dataset dataset;
        try {
            dataset = (Dataset)this.nestedWithColumnMapHelper(df, newColumnName, "", (Option<Function2<Column, Function1<String, Column>, Column>>)new Some(expression), (Option<Function2<Column, Function1<String, Column>, Column>>)None$.MODULE$)._1();
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().contains("Output field cannot be empty")) {
                throw new IllegalArgumentException(new StringBuilder(29).append("The column '").append(newColumnName).append("' already exists.").toString(), illegalArgumentException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw e;
            }
            throw throwable;
        }
        return dataset;
    }

    public Dataset<Row> nestedDropColumn(Dataset<Row> df, String columnToDrop) {
        return (Dataset)this.nestedWithColumnMapHelper(df, columnToDrop, "", this.nestedWithColumnMapHelper$default$4(), this.nestedWithColumnMapHelper$default$5())._1();
    }

    public Dataset<Row> nestedUnstruct(Dataset<Row> df, String columnToUnstruct) {
        StructType schema = df.schema();
        String[] path = new StringOps(Predef$.MODULE$.augmentString(columnToUnstruct)).split('.');
        IntRef lambdaIndex = IntRef.create((int)1);
        return df.select(this.mapStruct$1(schema, (Seq)Predef$.MODULE$.wrapRefArray((Object[])path), "", new ArrayContext(ArrayContext$.MODULE$.$lessinit$greater$default$1(), ArrayContext$.MODULE$.$lessinit$greater$default$2()), NestedArrayTransformations$.mapStruct$default$5$1(), columnToUnstruct, lambdaIndex));
    }

    private Tuple2<Dataset<Row>, String> nestedWithColumnMapHelper(Dataset<Row> df, String inputColumnName, String outputColumnName, Option<Function2<Column, Function1<String, Column>, Column>> expression, Option<Function2<Column, Function1<String, Column>, Column>> errorCondition) {
        String outputFieldName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(outputColumnName)).split('.'))).last();
        ObjectRef errorColumnName = ObjectRef.create((Object)"");
        String string = inputColumnName;
        String string2 = outputColumnName;
        boolean replaceExistingColumn = !(string != null ? !string.equals(string2) : string2 != null);
        IntRef lambdaIndex = IntRef.create((int)1);
        StructType schema = df.schema();
        String[] path = new StringOps(Predef$.MODULE$.augmentString(inputColumnName)).split('.');
        return new Tuple2((Object)df.select(this.mapStruct$2(schema, (Seq)Predef$.MODULE$.wrapRefArray((Object[])path), "", new ArrayContext(ArrayContext$.MODULE$.$lessinit$greater$default$1(), ArrayContext$.MODULE$.$lessinit$greater$default$2()), NestedArrayTransformations$.mapStruct$default$5$2(), expression, inputColumnName, outputFieldName, replaceExistingColumn, outputColumnName, errorCondition, errorColumnName, lambdaIndex)), (Object)((String)errorColumnName.elem));
    }

    private Option<Function2<Column, Function1<String, Column>, Column>> nestedWithColumnMapHelper$default$4() {
        return None$.MODULE$;
    }

    private Option<Function2<Column, Function1<String, Column>, Column>> nestedWithColumnMapHelper$default$5() {
        return None$.MODULE$;
    }

    public Dataset<Row> gatherErrors(Dataset<Row> df, String nestedErrorColumn, String globalErrorColumn) {
        if (new StringOps(Predef$.MODULE$.augmentString(globalErrorColumn)).contains((Object)BoxesRunTime.boxToCharacter((char)'.'))) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Global error columns should be at the root schema level. ").append("Value '").append(globalErrorColumn).append("' is not valid.").toString());
        }
        String tmpCol = SchemaUtils$.MODULE$.getUniqueName("tmp", (Option<StructType>)new Some((Object)df.schema()));
        Column flattenedColumn = this.flattenNestedArrays$1(df.schema(), nestedErrorColumn, nestedErrorColumn, df);
        Dataset dfOutput = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)NestedArrayTransformations$.$anonfun$gatherErrors$1(globalErrorColumn, x$10))) ? this.addColumnAfter((Dataset<Row>)df.withColumnRenamed(globalErrorColumn, tmpCol), tmpCol, globalErrorColumn, functions$.MODULE$.callUDF("arrayDistinctErrors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(flattenedColumn.isNull(), (Object)functions$.MODULE$.col(tmpCol)).otherwise((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(tmpCol), flattenedColumn})))}))).drop(functions$.MODULE$.col(tmpCol)) : df.withColumn(globalErrorColumn, functions$.MODULE$.callUDF("arrayDistinctErrors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{flattenedColumn})));
        return this.nestedDropColumn((Dataset<Row>)dfOutput, nestedErrorColumn);
    }

    public Dataset<Row> addColumnAfter(Dataset<Row> df, String afterColumn, String columnName, Column expr) {
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).flatMap((Function1 & Serializable & scala.Serializable)c -> {
            String string = c;
            String string2 = afterColumn;
            return !(string != null ? !string.equals(string2) : string2 != null) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c), expr.as(columnName)})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
    }

    private void validateErrorColumnName(String errorColumnName) {
        if (new StringOps(Predef$.MODULE$.augmentString(errorColumnName)).contains((Object)BoxesRunTime.boxToCharacter((char)'.'))) {
            throw new IllegalArgumentException(new StringBuilder(72).append("Error columns should be at the root schema level. ").append("Value '").append(errorColumnName).append("' is not valid.").toString());
        }
    }

    private boolean isLeafElement(Seq<String> path) {
        return path.lengthCompare(2) < 0;
    }

    private String toStructNotation(String inputStructField) {
        return new StringOps(Predef$.MODULE$.augmentString(inputStructField)).nonEmpty() ? new StringBuilder(2).append(inputStructField).append(".*").toString() : "";
    }

    private Function2<Column, Function1<String, Column>, Column> toExtendedTransformation(Function1<Column, Column> transformation) {
        return (Function2 & Serializable & scala.Serializable)(field, x$11) -> (Column)transformation.apply(field);
    }

    public Tuple2<String, String> splitParentField(String field, String parentField) {
        Tuple2 tuple2;
        String fixedField = field.trim();
        String fixedParentField = parentField.trim();
        String string = fixedField;
        String string2 = fixedParentField;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tuple2 = new Tuple2((Object)fixedField, (Object)"");
        } else {
            String parentFieldWithDot = fixedParentField.endsWith(".") ? fixedParentField : new StringBuilder(1).append(fixedParentField).append(".").toString();
            String parentFieldWithoutDot = fixedParentField.endsWith(".") ? (String)new StringOps(Predef$.MODULE$.augmentString(fixedParentField)).dropRight(1) : fixedParentField;
            tuple2 = fixedField.startsWith(parentFieldWithDot) ? new Tuple2((Object)parentFieldWithoutDot, (Object)fixedField.substring(parentFieldWithDot.length())) : new Tuple2((Object)"", (Object)fixedField);
        }
        return tuple2;
    }

    public Tuple2<String, String> splitByDeepestParent(String field, Seq<String> parentFields) {
        return parentFields.isEmpty() ? new Tuple2((Object)"", (Object)field) : (Tuple2)((TraversableOnce)parentFields.map((Function1 & Serializable & scala.Serializable)parentField -> MODULE$.splitParentField(field, (String)parentField), Seq$.MODULE$.canBuildFrom())).maxBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)NestedArrayTransformations$.$anonfun$splitByDeepestParent$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getLambdaName$1(IntRef lambdaIndex$1) {
        void var1_1;
        String name = new StringBuilder(1).append("v").append(lambdaIndex$1.elem).toString();
        ++lambdaIndex$1.elem;
        return var1_1;
    }

    private final Seq handleMatchedField$1(StructField field, Column curColumn, String parentPath, ArrayContext arrCtx, boolean isLeaf, String columnToUnstruct$1, Seq path$2, Option parentColumn$1, IntRef lambdaIndex$1) {
        return isLeaf ? NestedArrayTransformations$.handleMatchedLeaf$1(field, curColumn, columnToUnstruct$1) : this.handleMatchedNonLeaf$1(field, curColumn, parentPath, arrCtx, path$2, parentColumn$1, columnToUnstruct$1, lambdaIndex$1);
    }

    private static final Seq handleMatchedLeaf$1(StructField field, Column curColumn, String columnToUnstruct$1) {
        DataType dataType = field.dataType();
        if (!(dataType instanceof StructType)) {
            throw new IllegalArgumentException(new StringBuilder(19).append("Not a struct type: ").append(columnToUnstruct$1).toString());
        }
        StructType structType = (StructType)dataType;
        Seq seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)fld -> curColumn.getField(fld.name()).as(fld.name()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        return seq;
    }

    private final Column handleNestedArray$1(ArrayType dt, String parentPath, ArrayContext arrCtx, Seq path$1, Column curColumn$2, String lambdaName$1, String fieldName$1, String columnToUnstruct$1, IntRef lambdaIndex$1) {
        DataType deepestType = SchemaUtils$.MODULE$.getDeepestArrayType(dt);
        DataType dataType = deepestType;
        if (!(dataType instanceof StructType)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Not a struct field: ").append(columnToUnstruct$1).toString());
        }
        Function1 & Serializable & scala.Serializable innerArray = (Function1 & Serializable & scala.Serializable)x -> this.mapArray$1(dt, path$1, parentPath, arrCtx, (Option)new Some(x), true, columnToUnstruct$1, lambdaIndex$1);
        Column column = package$.MODULE$.transform(curColumn$2, (Function1 & Serializable & scala.Serializable)c -> (Column)((IterableLike)innerArray.apply(c)).head(), lambdaName$1).as(fieldName$1);
        return column;
    }

    private final Column handleNestedStruct$1(StructType dt, String parentPath, ArrayContext arrCtx, boolean isLeaf$1, Seq path$1, Column curColumn$2, String lambdaName$1, String fieldName$1, String columnToUnstruct$1, IntRef lambdaIndex$1) {
        Seq innerPath = isLeaf$1 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*"})) : (Seq)path$1.tail();
        return package$.MODULE$.transform(curColumn$2, (Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.struct(this.mapStruct$1(dt, innerPath, parentPath, arrCtx.withArraysUpdated(parentPath, (Column)x), (Option)new Some(x), columnToUnstruct$1, lambdaIndex$1)), lambdaName$1).as(fieldName$1);
    }

    /*
     * Unable to fully structure code
     */
    private final Seq mapArray$1(ArrayType schema, Seq path, String parentPath, ArrayContext arrCtx, Option parentColumn, boolean isParentArray, String columnToUnstruct$1, IntRef lambdaIndex$1) {
        block7: {
            block8: {
                block6: {
                    isLeaf = this.isLeafElement((Seq<String>)path);
                    lambdaName = NestedArrayTransformations$.getLambdaName$1(lambdaIndex$1);
                    fieldName = (String)path.head();
                    mappedFields = new ListBuffer();
                    var16_13 = false;
                    var17_14 = null;
                    var18_15 = parentColumn;
                    if (!None$.MODULE$.equals(var18_15)) break block6;
                    var10_16 = new Column(fieldName);
                    break block7;
                }
                if (!(var18_15 instanceof Some)) break block8;
                var16_13 = true;
                var17_14 = (Some)var18_15;
                col = (Column)var17_14.value();
                if (isParentArray) break block8;
                var10_16 = col.getField(fieldName).as(fieldName);
                break block7;
            }
            if (!var16_13) ** GOTO lbl-1000
            col = (Column)var17_14.value();
            if (isParentArray) {
                var10_16 = col;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var18_15);
            }
        }
        curColumn = var10_16;
        var23_21 = elemType = schema.elementType();
        if (var23_21 instanceof StructType) {
            var24_22 = (StructType)var23_21;
            var9_23 = this.handleNestedStruct$1(var24_22, parentPath, arrCtx, isLeaf, path, curColumn, lambdaName, fieldName, columnToUnstruct$1, lambdaIndex$1);
        } else if (var23_21 instanceof ArrayType) {
            var25_24 = (ArrayType)var23_21;
            var9_23 = this.handleNestedArray$1(var25_24, parentPath, arrCtx, path, curColumn, lambdaName, fieldName, columnToUnstruct$1, lambdaIndex$1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Not a struct field: ").append(columnToUnstruct$1).toString());
        }
        newColumn = var9_23;
        return newColumn == null ? mappedFields : (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{newColumn}))).$plus$plus((GenTraversableOnce)mappedFields, Seq$.MODULE$.canBuildFrom());
    }

    private static final Option mapArray$default$5$1() {
        return None$.MODULE$;
    }

    private static final boolean mapArray$default$6$1() {
        return false;
    }

    private final Seq handleMatchedNonLeaf$1(StructField field, Column curColumn, String parentPath, ArrayContext arrCtx, Seq path$2, Option parentColumn$1, String columnToUnstruct$1, IntRef lambdaIndex$1) {
        Seq seq;
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct(this.mapStruct$1(structType, (Seq)path$2.tail(), parentPath, arrCtx, (Option)new Some((Object)curColumn), columnToUnstruct$1, lambdaIndex$1)).as(field.name())}));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            seq = this.mapArray$1(arrayType, path$2, parentPath, arrCtx, parentColumn$1, NestedArrayTransformations$.mapArray$default$6$1(), columnToUnstruct$1, lambdaIndex$1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(42).append("Field '").append(field.name()).append("' is not a struct type or an array.").toString());
        }
        return seq;
    }

    private final Seq mapStruct$1(StructType schema, Seq path, String parentPath, ArrayContext arrCtx, Option parentColumn, String columnToUnstruct$1, IntRef lambdaIndex$1) {
        String fieldName = (String)path.head();
        String fieldPath = parentPath.isEmpty() ? fieldName : new StringBuilder(1).append(parentPath).append(".").append(fieldName).toString();
        boolean isLeaf = this.isLeafElement((Seq<String>)path);
        BooleanRef fieldFound = BooleanRef.create((boolean)false);
        Column[] newColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).flatMap((Function1 & Serializable & scala.Serializable)field -> {
            Seq seq;
            Column column;
            Option option = parentColumn;
            if (None$.MODULE$.equals(option)) {
                column = new Column(field.name());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Column col = (Column)some.value();
                column = col.getField(field.name()).as(field.name());
            } else {
                throw new MatchError((Object)option);
            }
            Column curColumn = column;
            if (field.name().compareToIgnoreCase(fieldName) != 0) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{curColumn}));
            } else {
                fieldFound$1.elem = true;
                seq = this.handleMatchedField$1((StructField)field, curColumn, fieldPath, arrCtx, isLeaf, columnToUnstruct$1, path, parentColumn, lambdaIndex$1);
            }
            return seq;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return Predef$.MODULE$.wrapRefArray((Object[])newColumns);
    }

    private static final Option mapStruct$default$5$1() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getLambdaName$2(IntRef lambdaIndex$2) {
        void var1_1;
        String name = new StringBuilder(1).append("v").append(lambdaIndex$2.elem).toString();
        ++lambdaIndex$2.elem;
        return var1_1;
    }

    private static final void ensureOutputColumnNonEmpty$1(String outputColumnName$1, String inputColumnName$1) {
        if (outputColumnName$1.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Output field cannot be empty when transforming an existing field '").append(inputColumnName$1).append("'").toString());
        }
    }

    private static final Option addErrorColumn$1(Option schema, Column column, ArrayContext arrCtx, Option errorCondition$1, ObjectRef errorColumnName$1, String inputColumnName$1) {
        return errorCondition$1.map((Function1 & Serializable & scala.Serializable)errorCond -> {
            Column errorColumn;
            block0: {
                errorColumnName$1.elem = SchemaUtils$.MODULE$.getUniqueName("errorList", (Option<StructType>)schema);
                errorColumn = functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)errorCond.apply((Object)column, (Function1 & Serializable & scala.Serializable)fieldName -> arrCtx.getField((String)fieldName))})).as((String)errorColumnName$1.elem);
                if (!new StringOps(Predef$.MODULE$.augmentString(inputColumnName$1)).contains((Object)BoxesRunTime.boxToCharacter((char)'.'))) break block0;
                String parent = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(inputColumnName$1)).split('.'))).dropRight(1))).mkString(".");
                errorColumnName$1.elem = new StringBuilder(1).append(parent).append(".").append((String)errorColumnName$1.elem).toString();
            }
            return errorColumn;
        });
    }

    private static final void handleStructLevelMap$1(Option expression$2, String inputColumnName$1, Option parentColumn$2, ListBuffer mappedFields$1, ArrayContext arrCtx$5, String outputFieldName$1, StructType schema$2, String outputColumnName$1, Option errorCondition$1, ObjectRef errorColumnName$1) {
        Option option = expression$2;
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(80).append("An expression must be specified if an asterix is used inside").append("input field name (").append(inputColumnName$1).append(").").toString());
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Function2 exp = (Function2)some.value();
        Column parentField = (Column)parentColumn$2.orNull(Predef$.MODULE$.$conforms());
        NestedArrayTransformations$.ensureOutputColumnNonEmpty$1(outputColumnName$1, inputColumnName$1);
        mappedFields$1.$plus$eq((Object)((Column)exp.apply((Object)parentField, (Function1 & Serializable & scala.Serializable)fieldName -> arrCtx$5.getField((String)fieldName))).as(outputFieldName$1));
        NestedArrayTransformations$.addErrorColumn$1((Option)new Some((Object)schema$2), parentField, arrCtx$5, errorCondition$1, errorColumnName$1, inputColumnName$1).foreach((Function1 & Serializable & scala.Serializable)x$5 -> mappedFields$1.$plus$eq(x$5));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void handleNewFieldRequest$1(String newFieldName, Option expression$2, String inputColumnName$1, ListBuffer mappedFields$1, ArrayContext arrCtx$5) {
        Option option = expression$2;
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(75).append("An expression must be specified if addition of a new field is ").append("requested (").append(inputColumnName$1).append(").").toString());
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Function2 exp = (Function2)some.value();
        mappedFields$1.$plus$eq((Object)((Column)exp.apply(null, (Function1 & Serializable & scala.Serializable)fieldName -> arrCtx$5.getField((String)fieldName))).as(newFieldName));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void handleInputFieldDoesNotExist$1(String fieldName, String outputFieldName$1, Option expression$2, String inputColumnName$1, Option parentColumn$2, ListBuffer mappedFields$1, ArrayContext arrCtx$5, StructType schema$2, String outputColumnName$1, Option errorCondition$1, ObjectRef errorColumnName$1) {
        String string = fieldName;
        String string2 = "*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            NestedArrayTransformations$.handleStructLevelMap$1(expression$2, inputColumnName$1, parentColumn$2, mappedFields$1, arrCtx$5, outputFieldName$1, schema$2, outputColumnName$1, errorCondition$1, errorColumnName$1);
        } else {
            String fieldToAdd = fieldName.isEmpty() ? outputFieldName$1 : fieldName;
            NestedArrayTransformations$.handleNewFieldRequest$1(fieldToAdd, expression$2, inputColumnName$1, mappedFields$1, arrCtx$5);
        }
    }

    private final Seq handleMatchedLeaf$2(StructField field, Column curColumn, String parentPath, ArrayContext arrCtx, Option expression$2, Seq path$3, Option parentColumn$2, String outputFieldName$1, StructType schema$2, ListBuffer mappedFields$1, boolean replaceExistingColumn$1, ObjectRef errorColumnName$1, String inputColumnName$1, Option errorCondition$1, String outputColumnName$1, IntRef lambdaIndex$2) {
        Nil$ nil$;
        Option option = expression$2;
        if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else if (option instanceof Some) {
            Seq seq;
            Some some = (Some)option;
            Function2 exp = (Function2)some.value();
            DataType dataType = field.dataType();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                seq = this.mapArray$2(arrayType, path$3, parentPath, arrCtx, parentColumn$2, NestedArrayTransformations$.mapArray$default$6$2(), errorColumnName$1, inputColumnName$1, outputFieldName$1, errorCondition$1, expression$2, lambdaIndex$2, outputColumnName$1, replaceExistingColumn$1);
            } else {
                Seq seq2;
                NestedArrayTransformations$.ensureOutputColumnNonEmpty$1(outputColumnName$1, inputColumnName$1);
                Column newColumn = ((Column)exp.apply((Object)curColumn, (Function1 & Serializable & scala.Serializable)fieldName -> arrCtx.getField((String)fieldName))).as(outputFieldName$1);
                NestedArrayTransformations$.addErrorColumn$1((Option)new Some((Object)schema$2), curColumn, arrCtx, errorCondition$1, errorColumnName$1, inputColumnName$1).foreach((Function1 & Serializable & scala.Serializable)x$6 -> mappedFields$1.$plus$eq(x$6));
                if (replaceExistingColumn$1) {
                    seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{newColumn}));
                } else {
                    mappedFields$1.$plus$eq((Object)newColumn);
                    seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{curColumn}));
                }
                seq = seq2;
            }
            nil$ = seq;
        } else {
            throw new MatchError((Object)option);
        }
        return nil$;
    }

    private final Seq handleMatchedNonLeaf$2(StructField field, Column curColumn, String parentPath, ArrayContext arrCtx, Seq path$3, Option parentColumn$2, Option expression$2, String inputColumnName$1, String outputFieldName$1, boolean replaceExistingColumn$1, String outputColumnName$1, Option errorCondition$1, ObjectRef errorColumnName$1, IntRef lambdaIndex$2) {
        Seq seq;
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct(this.mapStruct$2(structType, (Seq)path$3.tail(), parentPath, arrCtx, (Option)new Some((Object)curColumn), expression$2, inputColumnName$1, outputFieldName$1, replaceExistingColumn$1, outputColumnName$1, errorCondition$1, errorColumnName$1, lambdaIndex$2)).as(field.name())}));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            seq = this.mapArray$2(arrayType, path$3, parentPath, arrCtx, parentColumn$2, NestedArrayTransformations$.mapArray$default$6$2(), errorColumnName$1, inputColumnName$1, outputFieldName$1, errorCondition$1, expression$2, lambdaIndex$2, outputColumnName$1, replaceExistingColumn$1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(42).append("Field '").append(field.name()).append("' is not a struct type or an array.").toString());
        }
        return seq;
    }

    private final Seq handleMatchedField$2(StructField field, Column curColumn, String parentPath, ArrayContext arrCtx, boolean isLeaf, Option expression$2, Seq path$3, Option parentColumn$2, String outputFieldName$1, StructType schema$2, ListBuffer mappedFields$1, boolean replaceExistingColumn$1, ObjectRef errorColumnName$1, String inputColumnName$1, Option errorCondition$1, String outputColumnName$1, IntRef lambdaIndex$2) {
        return isLeaf ? this.handleMatchedLeaf$2(field, curColumn, parentPath, arrCtx, expression$2, path$3, parentColumn$2, outputFieldName$1, schema$2, mappedFields$1, replaceExistingColumn$1, errorColumnName$1, inputColumnName$1, errorCondition$1, outputColumnName$1, lambdaIndex$2) : this.handleMatchedNonLeaf$2(field, curColumn, parentPath, arrCtx, path$3, parentColumn$2, expression$2, inputColumnName$1, outputFieldName$1, replaceExistingColumn$1, outputColumnName$1, errorCondition$1, errorColumnName$1, lambdaIndex$2);
    }

    private final Seq mapStruct$2(StructType schema, Seq path, String parentPath, ArrayContext arrCtx, Option parentColumn, Option expression$2, String inputColumnName$1, String outputFieldName$1, boolean replaceExistingColumn$1, String outputColumnName$1, Option errorCondition$1, ObjectRef errorColumnName$1, IntRef lambdaIndex$2) {
        ListBuffer mappedFields = new ListBuffer();
        String fieldName = (String)path.head();
        String fieldPath = parentPath.isEmpty() ? fieldName : new StringBuilder(1).append(parentPath).append(".").append(fieldName).toString();
        boolean isLeaf = this.isLeafElement((Seq<String>)path);
        BooleanRef fieldFound = BooleanRef.create((boolean)false);
        Column[] newColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).flatMap((Function1 & Serializable & scala.Serializable)field -> {
            Seq seq;
            Column column;
            Option option = parentColumn;
            if (None$.MODULE$.equals(option)) {
                column = new Column(field.name());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Column col = (Column)some.value();
                column = col.getField(field.name()).as(field.name());
            } else {
                throw new MatchError((Object)option);
            }
            Column curColumn = column;
            if (field.name().compareToIgnoreCase(fieldName) != 0) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{curColumn}));
            } else {
                fieldFound$2.elem = true;
                seq = this.handleMatchedField$2((StructField)field, curColumn, fieldPath, arrCtx, isLeaf, expression$2, path, parentColumn, outputFieldName$1, schema, mappedFields, replaceExistingColumn$1, errorColumnName$1, inputColumnName$1, errorCondition$1, outputColumnName$1, lambdaIndex$2);
            }
            return seq;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        if (isLeaf) {
            String string = inputColumnName$1;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                NestedArrayTransformations$.handleStructLevelMap$1(expression$2, inputColumnName$1, parentColumn, mappedFields, arrCtx, outputFieldName$1, schema, outputColumnName$1, errorCondition$1, errorColumnName$1);
            } else if (!fieldFound.elem) {
                NestedArrayTransformations$.handleInputFieldDoesNotExist$1(fieldName, outputFieldName$1, expression$2, inputColumnName$1, parentColumn, mappedFields, arrCtx, schema, outputColumnName$1, errorCondition$1, errorColumnName$1);
            }
        }
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newColumns)).$plus$plus((GenTraversableOnce)mappedFields, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private static final Option mapStruct$default$5$2() {
        return None$.MODULE$;
    }

    private static final Function2 mapNestedArrayOfPrimitives$1(ArrayType schema, Function2 expr, String parentPath, ArrayContext arrCtx, boolean doFlatten, IntRef lambdaIndex$2) {
        Function2 & Serializable & scala.Serializable intersect;
        String lambdaName = NestedArrayTransformations$.getLambdaName$2(lambdaIndex$2);
        DataType elemType = schema.elementType();
        DataType dataType = elemType;
        if (dataType instanceof StructType) {
            throw new IllegalArgumentException("Unexpected usage of mapNestedArrayOfPrimitives() on structs.");
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function2 innerArray = NestedArrayTransformations$.mapNestedArrayOfPrimitives$1(arrayType, expr, parentPath, arrCtx, doFlatten, lambdaIndex$2);
            intersect = doFlatten ? (Function2 & Serializable & scala.Serializable)(x, gf) -> functions$.MODULE$.flatten(package$.MODULE$.transform(x, (Function1 & Serializable & scala.Serializable)x$7 -> (Column)innerArray.apply(x$7, gf), lambdaName)) : (Function2 & Serializable & scala.Serializable)(x, gf) -> package$.MODULE$.transform(x, (Function1 & Serializable & scala.Serializable)x$8 -> (Column)innerArray.apply(x$8, gf), lambdaName);
        } else {
            intersect = (Function2 & Serializable & scala.Serializable)(x, x$9) -> package$.MODULE$.transform(x, (Function1 & Serializable & scala.Serializable)InnerX -> {
                ArrayContext arrayContext = arrCtx.withArraysUpdated(parentPath, (Column)x);
                return (Column)expr.apply(InnerX, (Function1 & Serializable & scala.Serializable)fieldName -> arrayContext.getField((String)fieldName));
            }, lambdaName);
        }
        return intersect;
    }

    private static final boolean mapNestedArrayOfPrimitives$default$5$1() {
        return false;
    }

    private static final void handleErrorColumnOfArraysOfPrimitives$1(Option errorExpression, String parentPath, ArrayContext arrCtx, boolean doFlatten, ObjectRef errorColumnName$1, Column curColumn$3, String lambdaName$3, String inputColumnName$1, ListBuffer mappedFields$2) {
        errorExpression.map((Function1 & Serializable & scala.Serializable)errorExpr -> {
            Column errorColumn;
            block0: {
                errorColumnName$1.elem = SchemaUtils$.MODULE$.getUniqueName("errorList", (Option<StructType>)None$.MODULE$);
                Column column = errorColumn = doFlatten ? functions$.MODULE$.flatten(package$.MODULE$.transform(curColumn$3, (Function1 & Serializable & scala.Serializable)x -> {
                    ArrayContext arrayContext = arrCtx.withArraysUpdated(parentPath, (Column)x);
                    return (Column)errorExpr.apply(x, (Function1 & Serializable & scala.Serializable)fieldName -> arrayContext.getField((String)fieldName));
                }, lambdaName$3)).as((String)errorColumnName$1.elem) : package$.MODULE$.transform(curColumn$3, (Function1 & Serializable & scala.Serializable)x -> {
                    ArrayContext arrayContext = arrCtx.withArraysUpdated(parentPath, (Column)x);
                    return (Column)errorExpr.apply(x, (Function1 & Serializable & scala.Serializable)fieldName -> arrayContext.getField((String)fieldName));
                }, lambdaName$3).as((String)errorColumnName$1.elem);
                if (!new StringOps(Predef$.MODULE$.augmentString(inputColumnName$1)).contains((Object)BoxesRunTime.boxToCharacter((char)'.'))) break block0;
                String parent = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(inputColumnName$1)).split('.'))).dropRight(1))).mkString(".");
                errorColumnName$1.elem = new StringBuilder(1).append(parent).append(".").append((String)errorColumnName$1.elem).toString();
            }
            return mappedFields$2.$plus$eq((Object)errorColumn);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Column handlePrimitive$1(DataType dt, Option transformExpression, Option errorExpression, String parentPath, ArrayContext arrCtx, boolean doFlatten, boolean isLeaf$4, ListBuffer mappedFields$2, Column curColumn$3, String lambdaName$3, String outputFieldName$1, String fieldName$4, String outputColumnName$1, String inputColumnName$1, ObjectRef errorColumnName$1) {
        if (!isLeaf$4) throw new IllegalArgumentException(new StringBuilder(50).append("Field ").append(fieldName$4).append(" is not a struct or an array of struct type.").toString());
        Option option = transformExpression;
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        Function2 exp = (Function2)some.value();
        NestedArrayTransformations$.ensureOutputColumnNonEmpty$1(outputColumnName$1, inputColumnName$1);
        mappedFields$2.$plus$eq((Object)package$.MODULE$.transform(curColumn$3, (Function1 & Serializable & scala.Serializable)x -> {
            ArrayContext arrayContext = arrCtx.withArraysUpdated(parentPath, (Column)x);
            return (Column)exp.apply(x, (Function1 & Serializable & scala.Serializable)fieldName -> arrayContext.getField((String)fieldName));
        }, lambdaName$3).as(outputFieldName$1));
        NestedArrayTransformations$.handleErrorColumnOfArraysOfPrimitives$1(errorExpression, parentPath, arrCtx, doFlatten, errorColumnName$1, curColumn$3, lambdaName$3, inputColumnName$1, mappedFields$2);
        return curColumn$3;
    }

    private static final boolean handlePrimitive$default$6$1() {
        return false;
    }

    private final Column handleNestedArray$2(ArrayType dt, String parentPath, ArrayContext arrCtx, Seq path$4, Column curColumn$3, String lambdaName$3, String fieldName$4, Option errorCondition$1, Option expression$2, boolean isLeaf$4, ListBuffer mappedFields$2, String outputFieldName$1, String outputColumnName$1, String inputColumnName$1, ObjectRef errorColumnName$1, IntRef lambdaIndex$2, boolean replaceExistingColumn$1) {
        Column column;
        DataType deepestType = SchemaUtils$.MODULE$.getDeepestArrayType(dt);
        DataType dataType = deepestType;
        if (dataType instanceof StructType) {
            Function1 & Serializable & scala.Serializable innerArray = (Function1 & Serializable & scala.Serializable)x -> this.mapArray$2(dt, path$4, parentPath, arrCtx, (Option)new Some(x), true, errorColumnName$1, inputColumnName$1, outputFieldName$1, errorCondition$1, expression$2, lambdaIndex$2, outputColumnName$1, replaceExistingColumn$1);
            column = package$.MODULE$.transform(curColumn$3, (Function1 & Serializable & scala.Serializable)c -> (Column)((IterableLike)innerArray.apply(c)).head(), lambdaName$3).as(fieldName$4);
        } else {
            Option errorExpression = errorCondition$1.map((Function1 & Serializable & scala.Serializable)errorCond -> NestedArrayTransformations$.mapNestedArrayOfPrimitives$1(dt, errorCond, parentPath, arrCtx, true, lambdaIndex$2));
            boolean doFlatten = errorCondition$1.nonEmpty();
            column = NestedArrayTransformations$.handlePrimitive$1((DataType)dt, (Option)new Some((Object)NestedArrayTransformations$.mapNestedArrayOfPrimitives$1(dt, (Function2)expression$2.get(), parentPath, arrCtx, NestedArrayTransformations$.mapNestedArrayOfPrimitives$default$5$1(), lambdaIndex$2)), errorExpression, parentPath, arrCtx, doFlatten, isLeaf$4, mappedFields$2, curColumn$3, lambdaName$3, outputFieldName$1, fieldName$4, outputColumnName$1, inputColumnName$1, errorColumnName$1);
        }
        return column;
    }

    private final Column handleNestedStruct$2(StructType dt, String parentPath, ArrayContext arrCtx, boolean isLeaf$4, Seq path$4, Column curColumn$3, String lambdaName$3, String fieldName$4, Option expression$2, String inputColumnName$1, String outputFieldName$1, boolean replaceExistingColumn$1, String outputColumnName$1, Option errorCondition$1, ObjectRef errorColumnName$1, IntRef lambdaIndex$2) {
        Seq innerPath = isLeaf$4 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*"})) : (Seq)path$4.tail();
        return package$.MODULE$.transform(curColumn$3, (Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.struct(this.mapStruct$2(dt, innerPath, parentPath, arrCtx.withArraysUpdated(parentPath, (Column)x), (Option)new Some(x), expression$2, inputColumnName$1, outputFieldName$1, replaceExistingColumn$1, outputColumnName$1, errorCondition$1, errorColumnName$1, lambdaIndex$2)), lambdaName$3).as(fieldName$4);
    }

    public static final /* synthetic */ Function2 $anonfun$nestedWithColumnMapHelper$27(Function2 expr) {
        return (Function2 & Serializable & scala.Serializable)(x, gf) -> (Column)expr.apply(x, gf);
    }

    public static final /* synthetic */ Function2 $anonfun$nestedWithColumnMapHelper$29(Function2 cond) {
        return (Function2 & Serializable & scala.Serializable)(x, gf) -> (Column)cond.apply(x, gf);
    }

    /*
     * Unable to fully structure code
     */
    private final Seq mapArray$2(ArrayType schema, Seq path, String parentPath, ArrayContext arrCtx, Option parentColumn, boolean isParentArray, ObjectRef errorColumnName$1, String inputColumnName$1, String outputFieldName$1, Option errorCondition$1, Option expression$2, IntRef lambdaIndex$2, String outputColumnName$1, boolean replaceExistingColumn$1) {
        block7: {
            block8: {
                block6: {
                    isLeaf = this.isLeafElement((Seq<String>)path);
                    lambdaName = NestedArrayTransformations$.getLambdaName$2(lambdaIndex$2);
                    fieldName = (String)path.head();
                    mappedFields = new ListBuffer();
                    var22_19 = false;
                    var23_20 = null;
                    var24_21 = parentColumn;
                    if (!None$.MODULE$.equals(var24_21)) break block6;
                    var16_22 = new Column(fieldName);
                    break block7;
                }
                if (!(var24_21 instanceof Some)) break block8;
                var22_19 = true;
                var23_20 = (Some)var24_21;
                col = (Column)var23_20.value();
                if (isParentArray) break block8;
                var16_22 = col.getField(fieldName).as(fieldName);
                break block7;
            }
            if (!var22_19) ** GOTO lbl-1000
            col = (Column)var23_20.value();
            if (isParentArray) {
                var16_22 = col;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var24_21);
            }
        }
        curColumn = var16_22;
        var29_27 = elemType = schema.elementType();
        if (var29_27 instanceof StructType) {
            var30_28 = (StructType)var29_27;
            var15_29 = this.handleNestedStruct$2(var30_28, parentPath, arrCtx, isLeaf, path, curColumn, lambdaName, fieldName, expression$2, inputColumnName$1, outputFieldName$1, replaceExistingColumn$1, outputColumnName$1, errorCondition$1, errorColumnName$1, lambdaIndex$2);
        } else if (var29_27 instanceof ArrayType) {
            var31_30 = (ArrayType)var29_27;
            var15_29 = this.handleNestedArray$2(var31_30, parentPath, arrCtx, path, curColumn, lambdaName, fieldName, errorCondition$1, expression$2, isLeaf, mappedFields, outputFieldName$1, outputColumnName$1, inputColumnName$1, errorColumnName$1, lambdaIndex$2, replaceExistingColumn$1);
        } else {
            transformExpression = expression$2.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nestedWithColumnMapHelper$27(scala.Function2 ), (Lscala/Function2;)Lscala/Function2;)());
            errorExpression = errorCondition$1.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nestedWithColumnMapHelper$29(scala.Function2 ), (Lscala/Function2;)Lscala/Function2;)());
            var15_29 = NestedArrayTransformations$.handlePrimitive$1(var29_27, transformExpression, errorExpression, parentPath, arrCtx, NestedArrayTransformations$.handlePrimitive$default$6$1(), isLeaf, mappedFields, curColumn, lambdaName, outputFieldName$1, fieldName, outputColumnName$1, inputColumnName$1, errorColumnName$1);
        }
        newColumn = var15_29;
        return newColumn == null ? mappedFields : (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{newColumn}))).$plus$plus((GenTraversableOnce)mappedFields, Seq$.MODULE$.canBuildFrom());
    }

    private static final Option mapArray$default$5$2() {
        return None$.MODULE$;
    }

    private static final boolean mapArray$default$6$2() {
        return false;
    }

    private final Column handleNestedStruct$3(StructType schema, Seq columnPath, Option parentPath, Column inputColumn, int arrayLevel) {
        Column column;
        block8: {
            Column column2;
            DataType dataType;
            Column curCol;
            while (true) {
                Column column3;
                Option option;
                if (None$.MODULE$.equals(option = parentPath)) {
                    column3 = functions$.MODULE$.col((String)columnPath.head());
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Column parentCol = (Column)some.value();
                    column3 = parentCol.getField((String)columnPath.head());
                } else {
                    throw new MatchError((Object)option);
                }
                curCol = column3;
                if (this.isLeafElement((Seq<String>)columnPath)) {
                    column = curCol;
                    break block8;
                }
                dataType = schema.apply((String)columnPath.head()).dataType();
                if (!(dataType instanceof StructType)) break;
                StructType structType = (StructType)dataType;
                parentPath = new Some((Object)curCol);
                columnPath = (Seq)columnPath.tail();
                schema = structType;
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                column2 = this.handleNestedArray$3(arrayType, columnPath, curCol, inputColumn, arrayLevel + 1);
            } else {
                column2 = curCol;
            }
            column = column2;
        }
        return column;
    }

    private final Column handleNestedArray$3(ArrayType arr, Seq columnPath, Column parentPath, Column inputColumn, int arrayLevel) {
        Column column;
        DataType dataType = arr.elementType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            column = columnPath.isEmpty() ? functions$.MODULE$.flatten(parentPath) : (arrayLevel > 1 ? this.handleNestedStruct$3(structType, (Seq)columnPath.tail(), (Option)new Some((Object)functions$.MODULE$.flatten(parentPath)), inputColumn, arrayLevel) : functions$.MODULE$.flatten(this.handleNestedStruct$3(structType, (Seq)columnPath.tail(), (Option)new Some((Object)parentPath), inputColumn, arrayLevel + 1)));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            column = functions$.MODULE$.flatten(this.handleNestedArray$3(arrayType, columnPath, parentPath, inputColumn, arrayLevel + 1));
        } else {
            column = functions$.MODULE$.flatten(parentPath);
        }
        return column;
    }

    private final Column flattenNestedArrays$1(StructType schema, String inputColumnName, String nestedErrorColumn$1, Dataset df$1) {
        String[] path = new StringOps(Predef$.MODULE$.augmentString(nestedErrorColumn$1)).split('.');
        return this.handleNestedStruct$3(df$1.schema(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])path), (Option)None$.MODULE$, functions$.MODULE$.col(inputColumnName), 0);
    }

    public static final /* synthetic */ boolean $anonfun$gatherErrors$1(String globalErrorColumn$1, StructField x$10) {
        String string = x$10.name();
        String string2 = globalErrorColumn$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$splitByDeepestParent$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String parent = (String)tuple2._1();
        int n = parent.length();
        return n;
    }

    private NestedArrayTransformations$() {
        MODULE$ = this;
    }
}

