/*
 * Decompiled with CFR 0.152.
 */
package za.co.no9.jfixture;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import za.co.no9.jfixture.FixtureException;
import za.co.no9.jfixture.FixtureHandler;
import za.co.no9.jfixture.FixturesInput;
import za.co.no9.jfixture.IncludeHandler;
import za.co.no9.jfixture.NewHandlerHandler;
import za.co.no9.util.Optional;

public class Fixtures
implements Closeable {
    private Optional<FixturesInput> input;
    private FixtureHandler[] handlers;

    private Fixtures(FixturesInput input, FixtureHandler ... handlers) throws IOException {
        this.input = Optional.of(input);
        this.handlers = handlers;
        this.addHandler(new NewHandlerHandler());
        this.addHandler(new IncludeHandler());
    }

    public static Fixtures load(FixturesInput input, FixtureHandler ... handlers) throws IOException {
        return new Fixtures(input, handlers);
    }

    public static Fixtures load(FixturesInput input) throws IOException {
        return Fixtures.load(input, new FixtureHandler[0]);
    }

    public static Fixtures process(FixturesInput input) throws IOException, FixtureException {
        Fixtures fixtures = Fixtures.load(input);
        fixtures.processFixtures();
        return fixtures;
    }

    public void processFixtures(FixturesInput input) throws FixtureException {
        Optional<FixturesInput> oldInput = this.input;
        try {
            this.input = Optional.of(input);
            this.processFixtures();
        }
        finally {
            this.input = oldInput;
        }
    }

    public void processFixtures() throws FixtureException {
        for (Object fixtureDocument : this.input.orElse(FixturesInput.none()).fixtureDocuments()) {
            this.processDocument(fixtureDocument);
        }
        try {
            this.closeHandlers();
        }
        catch (IOException ex) {
            throw new FixtureException(ex);
        }
    }

    protected void closeHandlers() throws IOException {
        for (FixtureHandler handler : this.handlers) {
            handler.close();
        }
    }

    private void processDocument(Object fixtureDocument) throws FixtureException {
        if (!(fixtureDocument instanceof List)) {
            throw new FixtureException("The top-level of a fixture control file must be a sequence.");
        }
        this.processSequence((List)fixtureDocument);
    }

    private void processSequence(List<Map<String, Object>> sequenceOfFixtureInputs) throws FixtureException {
        for (Map<String, Object> fixtureInput : sequenceOfFixtureInputs) {
            this.processFixture(fixtureInput);
        }
    }

    private void processFixture(Map<String, Object> fixtureInput) throws FixtureException {
        if (fixtureInput.size() != 1) {
            throw new FixtureException("Each fixture must have a single selector.");
        }
        this.getHandler(fixtureInput).process(this, fixtureInput);
    }

    private FixtureHandler getHandler(Map<String, Object> fixtureInput) throws FixtureException {
        for (FixtureHandler handler : this.handlers) {
            if (!handler.canProcess(fixtureInput)) continue;
            return handler;
        }
        throw new FixtureException("No fixture handler has been registered to support " + fixtureInput.toString());
    }

    @Override
    public void close() throws IOException {
        this.input.orElse(FixturesInput.none()).close();
    }

    public FixtureHandler[] handlers() {
        return (FixtureHandler[])this.handlers.clone();
    }

    public void addHandler(FixtureHandler fixtureHandler) {
        this.handlers = Arrays.copyOf(this.handlers, this.handlers.length + 1);
        this.handlers[this.handlers.length - 1] = fixtureHandler;
    }

    public <T extends FixtureHandler> Optional<T> findHandler(Class<T> classInstance) {
        for (FixtureHandler handler : this.handlers()) {
            if (!classInstance.isInstance(handler)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public <T extends FixtureHandler> T handler(Class<T> classInstance) {
        return (T)((FixtureHandler)this.findHandler(classInstance).get());
    }
}

