/*
 * Decompiled with CFR 0.152.
 */
package za.co.no9.jfixture;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.yaml.snakeyaml.Yaml;

public final class FixturesInput
implements Closeable {
    private final InputStream inputStream;
    private final Iterable<Object> fixtureDocuments;

    private FixturesInput(InputStream inputStream) {
        Yaml yaml = new Yaml();
        this.inputStream = inputStream;
        this.fixtureDocuments = yaml.loadAll(inputStream);
    }

    public static FixturesInput fromString(String fixtureContent) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fixtureContent.getBytes());
        return new FixturesInput(inputStream);
    }

    public static FixturesInput fromResources(String resourceName) throws IOException {
        ClassLoader loader = FixturesInput.class.getClassLoader();
        InputStream inputStream = loader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new IOException("The resource " + resourceName + " could not be accessed.");
        }
        return new FixturesInput(inputStream);
    }

    public static FixturesInput fromInputStream(InputStream inputStream) throws IOException {
        return new FixturesInput(inputStream);
    }

    public static FixturesInput fromLocation(String locationName) throws IOException {
        if (locationName.startsWith("string:")) {
            return FixturesInput.fromString(locationName.substring(7));
        }
        if (locationName.startsWith("resource:")) {
            return FixturesInput.fromResources(locationName.substring(9));
        }
        throw new IOException("Resource has unknown prefix: " + locationName);
    }

    public Iterable<Object> fixtureDocuments() {
        return this.fixtureDocuments;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public static FixturesInput none() {
        return FixturesInput.fromString("");
    }
}

