/*
 * Decompiled with CFR 0.152.
 */
package za.co.no9.jfixture;

import java.sql.DriverManager;
import java.sql.SQLException;
import za.co.no9.jfixture.FixtureException;
import za.co.no9.jfixture.JDBCHandler;
import za.co.no9.jfixture.JDBCOperation;
import za.co.no9.jfixture.YAMLDSL;

public class JDBCConnect
extends JDBCOperation {
    public JDBCConnect(String selector) {
        super(selector);
    }

    @Override
    protected void processOperation(JDBCHandler handler, Object fixtureInput) throws FixtureException {
        YAMLDSL.YAMLMap fixtureMap = YAMLDSL.fromYAML(fixtureInput).mapElseException(this.exceptionMessagePrefix() + ": Excepts a map");
        String driverName = fixtureMap.field("driver").ifBlankException(this.exceptionMessagePrefix() + ": Field driver has not been set.").asString();
        try {
            Class.forName(driverName);
            handler.connection(DriverManager.getConnection(fixtureMap.field("url").ifBlankException(this.exceptionMessagePrefix() + ": Field driver has not been set.").asString(), fixtureMap.field("username").ifBlankDefault("").asString(), fixtureMap.field("password").ifBlankDefault("").asString()));
            handler.autoCloseConnection(fixtureMap.field("autoclose").ifEmptyDefault(true).asBoolean());
        }
        catch (ClassNotFoundException e) {
            throw new FixtureException(this.exceptionMessagePrefix() + "Loading of the driver class " + driverName + " failed:" + e.getMessage());
        }
        catch (SQLException e) {
            throw new FixtureException(this.exceptionMessagePrefix() + "Unable to connect: " + e.getMessage());
        }
    }
}

