/*
 * Decompiled with CFR 0.152.
 */
package za.co.no9.jfixture;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import za.co.no9.jfixture.BasicFixtureHandler;
import za.co.no9.jfixture.FixtureException;
import za.co.no9.jfixture.JDBCConnect;
import za.co.no9.jfixture.JDBCCreateTable;
import za.co.no9.jfixture.JDBCInsert;
import za.co.no9.jfixture.JDBCOperation;
import za.co.no9.jfixture.JDBCSql;
import za.co.no9.util.Optional;

public class JDBCHandler
extends BasicFixtureHandler {
    private Optional<Connection> connection;
    private List<JDBCOperation> operations = Arrays.asList(new JDBCConnect("jdbc-connect"), new JDBCCreateTable("jdbc-create-table"), new JDBCInsert("jdbc-insert"), new JDBCSql("jdbc-sql"));
    private boolean autoCloseConnection = true;

    public JDBCHandler(Connection connection) {
        this.connection = Optional.of(connection);
        this.autoCloseConnection = false;
    }

    public JDBCHandler() {
    }

    @Override
    public boolean canProcess(Map<String, Object> fixtureInput) {
        return this.findOperation(fixtureInput).isPresent();
    }

    private Optional<JDBCOperation> findOperation(Map<String, Object> fixtureInput) {
        for (JDBCOperation operation : this.operations) {
            if (!operation.canProcess(fixtureInput)) continue;
            return Optional.of(operation);
        }
        return Optional.empty();
    }

    @Override
    public void process(Map<String, Object> fixtureInput) throws FixtureException {
        Optional<JDBCOperation> operation = this.findOperation(fixtureInput);
        if (operation.isPresent()) {
            operation.get().process(this, fixtureInput);
        }
    }

    public static JDBCHandler create() {
        return new JDBCHandler();
    }

    public static JDBCHandler create(Connection connection) {
        return new JDBCHandler(connection);
    }

    public boolean isConnected() {
        return this.connection.isPresent();
    }

    public Connection connection() {
        return this.connection.get();
    }

    protected void connection(Connection connection) {
        this.connection = Optional.of(connection);
        this.autoCloseConnection = true;
    }

    protected void autoCloseConnection(boolean autoCloseConnection) {
        this.autoCloseConnection = autoCloseConnection;
    }

    @Override
    public void close() throws IOException {
        if (this.autoCloseConnection) {
            if (this.connection.isPresent()) {
                try {
                    this.connection.get().rollback();
                    this.connection.get().close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            this.connection = Optional.empty();
        }
    }
}

