/*
 * Decompiled with CFR 0.152.
 */
package za.co.no9.jfixture;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import za.co.no9.jfixture.FixtureException;
import za.co.no9.jfixture.JDBCHandler;

public abstract class JDBCOperation {
    protected final String selector;

    public JDBCOperation(String selector) {
        this.selector = selector;
    }

    protected boolean canProcess(Map<String, Object> fixtureInput) {
        return fixtureInput.containsKey(this.selector());
    }

    protected void process(JDBCHandler handler, Map<String, Object> fixtureInput) throws FixtureException {
        this.processOperation(handler, fixtureInput.get(this.selector));
    }

    protected abstract void processOperation(JDBCHandler var1, Object var2) throws FixtureException;

    protected String selector() {
        return this.selector;
    }

    protected String exceptionMessagePrefix() {
        return "JDBCHandler: " + this.selector() + ": ";
    }

    protected void executeStatement(JDBCHandler handler, String buffer) throws FixtureException {
        Statement statement = null;
        try {
            statement = handler.connection().createStatement();
            statement.execute(String.valueOf(buffer));
        }
        catch (SQLException e) {
            throw new FixtureException(this.exceptionMessagePrefix() + "Error executing statement: " + buffer + ": " + e.toString());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }
}

