/*
 * Decompiled with CFR 0.152.
 */
package za.co.no9.util;

import za.co.no9.util.function.Consumer;

public class Optional<T> {
    private T element;

    private Optional(T element) {
        this.element = element;
    }

    public static <T> Optional<T> of(T element) {
        if (element == null) {
            throw new NullPointerException("Attempted to create an optional with a null element.");
        }
        return new Optional<T>(element);
    }

    public static <T> Optional<T> empty() {
        return new Optional<Object>(null);
    }

    public boolean isPresent() {
        return this.element != null;
    }

    public boolean isNotPresent() {
        return this.element == null;
    }

    public T get() {
        if (this.element == null) {
            throw new NullPointerException("Attempted get on null optional element.");
        }
        return this.element;
    }

    public T orElse(T elseElement) {
        return this.element == null ? elseElement : this.element;
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.element != null) {
            consumer.accept(this.element);
        }
    }
}

