/*
 * Decompiled with CFR 0.152.
 */
package zone.gryphon.screech.gson2;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Objects;
import zone.gryphon.screech.Callback;
import zone.gryphon.screech.ResponseDecoder;
import zone.gryphon.screech.model.ResponseHeaders;
import zone.gryphon.screech.util.ExpandableByteBuffer;

public class GsonDecoder
implements ResponseDecoder {
    private final Gson gson;
    private final Type type;
    private final Callback<Object> callback;
    private final ExpandableByteBuffer buffer;

    public GsonDecoder(Gson gson, ResponseHeaders responseHeaders, Type type, Callback<Object> callback) {
        this.gson = Objects.requireNonNull(gson, "gson");
        this.type = Objects.requireNonNull(type, "type");
        this.callback = Objects.requireNonNull(callback, "callback");
        this.buffer = Objects.requireNonNull(responseHeaders, "responseHeaders").getContentLength().map(ExpandableByteBuffer::create).orElseGet(ExpandableByteBuffer::createEmpty);
    }

    public void content(ByteBuffer content) {
        if (content == null || content.remaining() == 0) {
            return;
        }
        this.buffer.append(content);
    }

    public void complete() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.buffer.createInputStream()));){
            this.callback.onSuccess(this.gson.fromJson((Reader)reader, this.type));
        }
        catch (Throwable t) {
            this.callback.onFailure(t);
        }
    }

    public void abort() {
        this.buffer.clear();
    }

    public String toString() {
        return "GsonDecoder{Gson@" + this.gson.hashCode() + '}';
    }
}

