/*
 * Decompiled with CFR 0.152.
 */
package zone.gryphon.screech.gson2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import zone.gryphon.screech.Callback;
import zone.gryphon.screech.RequestEncoder;

public class GsonEncoder
implements RequestEncoder {
    private final Gson gson;

    public GsonEncoder() {
        this(new GsonBuilder().create());
    }

    public GsonEncoder(Gson gson) {
        this.gson = Objects.requireNonNull(gson, "gson");
    }

    public <T> void encode(T entity, Callback<ByteBuffer> callback) {
        try {
            callback.onSuccess((Object)ByteBuffer.wrap(this.gson.toJson(entity).getBytes(StandardCharsets.UTF_8)));
        }
        catch (Throwable t) {
            callback.onFailure(t);
        }
    }

    public String toString() {
        return "GsonEncoder{Gson@" + this.gson.hashCode() + '}';
    }
}

