/*
 * Decompiled with CFR 0.152.
 */
package zone.gryphon.screech;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import zone.gryphon.screech.Client;
import zone.gryphon.screech.model.HttpParam;
import zone.gryphon.screech.model.RequestBody;
import zone.gryphon.screech.model.ResponseHeaders;
import zone.gryphon.screech.model.SerializedRequest;

public class JettyScreechClient
implements Client {
    private final HttpClient client;

    private static ResponseHeaders toScreechResponse(Response response) {
        List headers = response.getHeaders().stream().map(header -> new HttpParam(header.getName(), header.getValue())).collect(Collectors.toList());
        return ResponseHeaders.builder().status(response.getStatus()).headers(headers).build();
    }

    private static HttpClient createAndConfigureClient() {
        HttpClient client = new HttpClient();
        client.setMaxConnectionsPerDestination(Short.MAX_VALUE);
        client.setMaxRequestsQueuedPerDestination(Short.MAX_VALUE);
        client.setFollowRedirects(true);
        return client;
    }

    public JettyScreechClient() {
        this(JettyScreechClient.createAndConfigureClient());
    }

    public JettyScreechClient(HttpClient client) {
        this.client = Objects.requireNonNull(client, "client may not be null");
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start jetty client", e);
        }
    }

    public void request(SerializedRequest request, Client.ClientCallback callback) {
        this.toJettyRequest(request).send((Response.CompleteListener)new PassThroughResponseAdapter(callback));
    }

    public void close() throws IOException {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new IOException("Failed to close client", e);
        }
    }

    private Request toJettyRequest(SerializedRequest request) {
        Objects.requireNonNull(request, "SerializedRequest may not be null");
        Request jettyRequest = this.client.newRequest(request.getUri()).method(request.getMethod());
        if (request.getHeaders() != null) {
            for (HttpParam header : request.getHeaders()) {
                jettyRequest.header(header.getKey(), header.getValue());
            }
        }
        if (request.getQueryParams() != null) {
            for (HttpParam queryParam : request.getQueryParams()) {
                jettyRequest.param(queryParam.getKey(), queryParam.getValue());
            }
        }
        if (request.getRequestBody() != null) {
            RequestBody requestBody = request.getRequestBody();
            jettyRequest.content((ContentProvider)new ByteBufferContentProvider(requestBody.getContentType(), new ByteBuffer[]{requestBody.getBody()}));
        }
        return jettyRequest;
    }

    public String toString() {
        return "JettyScreechClient{HttpClient@" + this.client.hashCode() + '}';
    }

    private static class PassThroughResponseAdapter
    extends Response.Listener.Adapter {
        private final Client.ClientCallback callback;
        private volatile Client.ContentCallback contentCallback;

        private PassThroughResponseAdapter(Client.ClientCallback callback) {
            this.callback = Objects.requireNonNull(callback, "client callback may not be null");
        }

        public void onHeaders(Response response) {
            this.contentCallback = this.callback.headers(JettyScreechClient.toScreechResponse(response));
        }

        public void onContent(Response response, ByteBuffer content) {
            this.contentCallback.content(content);
        }

        public void onComplete(Result result) {
            if (result.getFailure() != null) {
                this.callback.abort(result.getFailure());
            } else {
                this.callback.complete();
            }
        }
    }
}

