/*
 * Decompiled with CFR 0.152.
 */
package webdev.core;

import java.util.Map;
import webdev.core.CanFail;

public class InitResponse
extends CanFail {
    private Map<String, String> Data;
    private boolean WasSuccessful;
    private boolean HasRedirect;
    private String instructions;

    public InitResponse(Map<String, String> response) {
        this.Data = response;
        this.load();
    }

    public final Map<String, String> getData() {
        return this.Data;
    }

    protected final boolean getWasSuccessful() {
        return this.WasSuccessful;
    }

    protected final void setWasSuccessful(boolean value) {
        this.WasSuccessful = value;
    }

    protected final boolean getHasRedirect() {
        return this.HasRedirect;
    }

    protected final void setHasRedirect(boolean value) {
        this.HasRedirect = value;
    }

    private void load() {
        if (this.getData().containsKey("status")) {
            this.setWasSuccessful(this.getData().get("status").toLowerCase().equals("ok"));
        }
        if (this.getData().containsKey("browserurl")) {
            this.setHasRedirect(true);
        }
        if (this.getData().containsKey("instructions")) {
            this.setInstructions(this.getData().get("instructions"));
        }
        if (this.getWasSuccessful()) {
            return;
        }
        if (this.getData().containsKey("error")) {
            this.fail(this.getData().get("error"));
        }
    }

    public final String pollUrl() {
        return this.getData().containsKey("pollurl") ? this.getData().get("pollurl") : "";
    }

    public final boolean success() {
        return this.getWasSuccessful();
    }

    public final String redirectLink() {
        return this.getHasRedirect() ? this.getData().get("browserurl") : "";
    }

    public final String instructions() {
        return this.getWasSuccessful() ? this.getInstructions() : "";
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }
}

