/*
 * Decompiled with CFR 0.152.
 */
package webdev.core;

import java.math.BigDecimal;
import java.util.Map;
import webdev.core.CanFail;
import webdev.core.IResponse;

public class StatusResponse
extends CanFail
implements IResponse {
    private Map<String, String> Data;
    private boolean WasSuccessful;
    private String Reference;
    private BigDecimal Amount = new BigDecimal(0);
    private boolean WasPaid;

    public StatusResponse(Map<String, String> response) {
        this.Data = response;
        this.load();
    }

    public final Map<String, String> getData() {
        return this.Data;
    }

    protected final boolean getWasSuccessful() {
        return this.WasSuccessful;
    }

    protected final void setWasSuccessful(boolean value) {
        this.WasSuccessful = value;
    }

    public final String getReference() {
        return this.Reference;
    }

    public final void setReference(String value) {
        this.Reference = value;
    }

    public final BigDecimal getAmount() {
        return this.Amount;
    }

    public final void setAmount(BigDecimal value) {
        this.Amount = value;
    }

    public final boolean getWasPaid() {
        return this.WasPaid;
    }

    public final void setWasPaid(boolean value) {
        this.WasPaid = value;
    }

    @Override
    public final boolean success() {
        return this.getWasSuccessful();
    }

    private void load() {
        if (!this.getData().containsKey("error")) {
            this.setWasSuccessful(true);
        }
        if (this.getData().containsKey("status")) {
            this.setWasPaid(this.getData().get("status").toLowerCase().equals("paid"));
        }
        if (this.getData().containsKey("amount")) {
            this.setAmount(new BigDecimal(this.getData().get("amount")));
        }
        if (this.getData().containsKey("reference")) {
            this.setReference(this.getData().get("reference"));
        }
        if (this.getWasSuccessful()) {
            return;
        }
        if (this.getData().containsKey("error")) {
            this.fail(this.getData().get("error"));
        }
    }

    public final String pollUrl() {
        return this.getData().containsKey("pollurl") ? this.getData().get("pollurl") : "";
    }

    public final boolean paid() {
        return this.getWasPaid();
    }
}

