/*
 * Decompiled with CFR 0.152.
 */
package webdev.helpers;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;

public final class Hash {
    public static String make(Map<String, String> values, String integrationKey) {
        String str = Hash.concat(values).concat(integrationKey);
        return Hash.generateHash(str);
    }

    public static String generateHash(String input) {
        String hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            digest.reset();
            digest.update(input.getBytes(StandardCharsets.UTF_8));
            hash = String.format("%040x", new BigInteger(1, digest.digest()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash.toUpperCase();
    }

    private static String concat(Map<String, String> items) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : items.entrySet()) {
            if (pair.getKey().toLowerCase().equals("hash")) continue;
            sb.append(pair.getValue());
        }
        return sb.toString();
    }

    public static boolean verify(Map<String, String> data, String integrationKey) {
        return Hash.make(data, integrationKey).equals(data.get("hash"));
    }
}

