/*
 * Decompiled with CFR 0.152.
 */
package webdev.helpers;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import webdev.payments.MobileMoneyMethod;

public final class Utils {
    public static BigDecimal b(double value) {
        return new BigDecimal(value);
    }

    public static BigDecimal b(int value) {
        return new BigDecimal(value);
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String urlEncode(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", Utils.urlEncode(entry.getKey().toString()), Utils.urlEncode(entry.getValue().toString())));
        }
        return sb.toString();
    }

    public static String flattenCollection(HashMap<String, BigDecimal> items) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, BigDecimal> pair : items.entrySet()) {
            sb.append(pair.getKey());
            sb.append(", ");
        }
        return sb.toString();
    }

    public static BigDecimal addCollectionValues(HashMap<String, BigDecimal> items) {
        BigDecimal number = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> pair : items.entrySet()) {
            number = number.add(pair.getValue());
        }
        return number;
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    public static boolean validateEmail(String email) {
        return Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$").matcher(email).matches();
    }

    public static LinkedHashMap<String, String> parseQueryString(String qs) {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = qs.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(Utils.urlDecode(pair.substring(0, idx)), Utils.urlDecode(pair.substring(idx + 1)));
        }
        return query_pairs;
    }

    public static String getString(MobileMoneyMethod method) {
        switch (method) {
            case Ecocash: {
                return "ecocash";
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

