/*
 * Decompiled with CFR 0.152.
 */
package webdev.payments;

import java.math.BigDecimal;
import java.util.HashMap;
import webdev.helpers.Utils;

public class Payment {
    private boolean override = false;
    public String defaultDescription = "";
    public String AuthEmail = "";
    private String Reference;
    private HashMap<String, BigDecimal> Items;

    public Payment(String reference, String authEmail) {
        this.setReference(reference);
        this.Items = new HashMap();
        this.AuthEmail = authEmail;
    }

    public Payment(String reference, HashMap<String, BigDecimal> values, String authEmail) {
        this.setReference(reference);
        this.Items = values;
        this.AuthEmail = authEmail;
    }

    public final String getReference() {
        return this.Reference;
    }

    public final void setReference(String value) {
        this.Reference = value;
    }

    private HashMap<String, BigDecimal> getItems() {
        return this.Items;
    }

    public final BigDecimal getTotal() {
        return this.calculateTotal();
    }

    public final Payment add(String title, double amount) {
        this.getItems().put(title, new BigDecimal(amount));
        return this;
    }

    public final Payment add(String title, int amount) {
        this.getItems().put(title, new BigDecimal(amount));
        return this;
    }

    public final Payment add(String title, BigDecimal amount) {
        this.getItems().put(title, amount);
        return this;
    }

    public final Payment remove(String title) {
        HashMap<String, BigDecimal> items = this.getItems();
        if (items.containsKey(title)) {
            this.getItems().remove(title);
        }
        return this;
    }

    public final String itemsDescription() {
        if (this.override) {
            return this.defaultDescription;
        }
        return Utils.flattenCollection(this.getItems()).trim();
    }

    private BigDecimal calculateTotal() {
        return Utils.addCollectionValues(this.getItems());
    }

    public void setDefaultDescription(String description) {
        this.defaultDescription = description;
        this.override = true;
    }

    public final HashMap<String, String> toDictionary() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("resulturl", "");
        map.put("returnurl", "");
        map.put("reference", this.getReference());
        map.put("amount", this.getTotal().toString());
        map.put("id", "");
        map.put("additionalinfo", this.itemsDescription());
        map.put("authemail", this.AuthEmail);
        map.put("status", "Message");
        return map;
    }
}

