/*
 * Decompiled with CFR 0.152.
 */
package webdev.payments;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import webdev.core.InitResponse;
import webdev.core.StatusResponse;
import webdev.exceptions.ConnectionException;
import webdev.exceptions.EmptyCartException;
import webdev.exceptions.HashMismatchException;
import webdev.exceptions.InvalidReferenceException;
import webdev.helpers.Hash;
import webdev.helpers.Utils;
import webdev.http.Client;
import webdev.payments.Payment;

public class Paynow {
    private String ResultUrl = "http://localhost";
    private String ReturnUrl = "http://localhost";
    private String IntegrationKey;
    private Client Client;
    private String IntegrationId;

    public Paynow(String integrationId, String integrationKey) {
        this(integrationId, integrationKey, null);
    }

    public Paynow(String integrationId, String integrationKey, String resultUrl) {
        if (integrationId.isEmpty()) {
            throw new IllegalArgumentException("Integration id cannot be empty");
        }
        if (integrationKey.isEmpty()) {
            throw new IllegalArgumentException("Integration key cannot be empty");
        }
        this.setIntegrationId(integrationId);
        this.setIntegrationKey(integrationKey);
        if (resultUrl != null) {
            this.setResultUrl(resultUrl);
        }
        this.setClient(new Client());
    }

    public final String getResultUrl() {
        return this.ResultUrl;
    }

    public final void setResultUrl(String value) {
        this.ResultUrl = value;
    }

    public final String getReturnUrl() {
        return this.ReturnUrl;
    }

    public final void setReturnUrl(String value) {
        this.ReturnUrl = value;
    }

    public final String getIntegrationKey() {
        return this.IntegrationKey;
    }

    public final void setIntegrationKey(String value) {
        this.IntegrationKey = value;
    }

    public final Client getClient() {
        return this.Client;
    }

    public final void setClient(Client value) {
        this.Client = value;
    }

    public final String getIntegrationId() {
        return this.IntegrationId;
    }

    public final void setIntegrationId(String value) {
        this.IntegrationId = value;
    }

    public final Payment createPayment(String reference, HashMap<String, BigDecimal> values) {
        return this.createPayment(reference, values, "");
    }

    public final Payment createPayment(String reference, String email) {
        return this.createPayment(reference, null, email);
    }

    public final Payment createPayment(String reference) {
        return this.createPayment(reference, null, "");
    }

    public final Payment createPayment(String reference, HashMap<String, BigDecimal> values, String authEmail) {
        return values != null ? new Payment(reference, values, authEmail) : new Payment(reference, authEmail);
    }

    public final InitResponse send(Payment payment) {
        if (payment.getReference().isEmpty()) {
            throw new InvalidReferenceException();
        }
        if (payment.getTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EmptyCartException();
        }
        return this.init(payment);
    }

    public final StatusResponse pollTransaction(String url) throws HashMismatchException, ConnectionException {
        try {
            String response = this.getClient().PostAsync(url, null);
            LinkedHashMap<String, String> data = Utils.parseQueryString(response);
            if (!data.containsKey("hash") || !Hash.verify(data, this.getIntegrationKey())) {
                throw new HashMismatchException((String)((HashMap)data).get("Error"));
            }
            return new StatusResponse(data);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.getMessage());
        }
    }

    public final StatusResponse processStatusUpdate(String response) {
        LinkedHashMap<String, String> data = Utils.parseQueryString(response);
        if (!data.containsKey("hash") || !Hash.verify(data, this.getIntegrationKey())) {
            throw new HashMismatchException((String)((HashMap)data).get("Error"));
        }
        return new StatusResponse(data);
    }

    public final StatusResponse processStatusUpdate(HashMap<String, String> response) {
        if (!response.containsKey("hash") || !Hash.verify(response, this.getIntegrationKey())) {
            throw new HashMismatchException(response.get("Error"));
        }
        return new StatusResponse(response);
    }

    public final InitResponse sendMobile(Payment payment, String phone, String method) {
        if (payment.getReference().isEmpty()) {
            throw new InvalidReferenceException();
        }
        if (payment.getTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EmptyCartException();
        }
        return this.initMobile(payment, phone, method);
    }

    private InitResponse initMobile(Payment payment, String phone, String method) throws ConnectionException, HashMismatchException {
        try {
            HashMap<String, String> data = this.formatMobileInitRequest(payment, phone, method);
            String email = data.get("authemail");
            if (email == null || email.isEmpty() || !Utils.validateEmail(email)) {
                throw new IllegalArgumentException("Auth email is required for mobile transactions. Please pass a valid email address to the createPayment method");
            }
            LinkedHashMap<String, String> response = Utils.parseQueryString(this.getClient().PostAsync("https://www.paynow.co.zw/interface/remotetransaction", data));
            if (!(((String)((HashMap)response).get("status")).toLowerCase().equals("error") || response.containsKey("hash") && Hash.verify(response, this.getIntegrationKey()))) {
                throw new HashMismatchException((String)((HashMap)response).get("Error"));
            }
            return new InitResponse(response);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.getMessage());
        }
    }

    private InitResponse init(Payment payment) throws ConnectionException, HashMismatchException {
        try {
            HashMap<String, String> data = this.formatInitRequest(payment);
            LinkedHashMap<String, String> response = Utils.parseQueryString(this.getClient().PostAsync("https://www.paynow.co.zw/interface/initiatetransaction", data));
            if (((String)((HashMap)response).get("status")).toLowerCase().equals("error") || !response.containsKey("hash") || !Hash.verify(response, this.getIntegrationKey())) {
                throw new HashMismatchException((String)((HashMap)response).get("Error"));
            }
            return new InitResponse(response);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.getMessage());
        }
    }

    private HashMap<String, String> formatInitRequest(Payment payment) {
        HashMap<String, String> items = payment.toDictionary();
        items.put("returnurl", this.getReturnUrl().trim());
        items.put("resulturl", this.getResultUrl().trim());
        items.put("id", this.getIntegrationId());
        items.put("hash", Hash.make(items, this.getIntegrationKey()));
        return items;
    }

    private HashMap<String, String> formatMobileInitRequest(Payment payment, String phone, String method) {
        HashMap<String, String> items = payment.toDictionary();
        items.put("returnurl", this.getReturnUrl().trim());
        items.put("resulturl", this.getResultUrl().trim());
        items.put("id", this.getIntegrationId());
        items.put("phone", phone);
        items.put("method", method);
        items.put("hash", Hash.make(items, this.getIntegrationKey()));
        return items;
    }
}

