/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.constants;

public enum TransactionStatus {
    OK("Ok", "Transaction initiation request is successful."),
    PAID("Paid", "Transaction paid successfully, the merchant will receive the funds at next settlement."),
    CANCELLED("Cancelled", "The transaction has been cancelled in Paynow and may not be resumed and needs to be recreated."),
    SENT("Sent", "Transaction has been created in Paynow and an up stream system, the customer has been referred to that upstream system but has not yet made payment."),
    DELIVERY("Awaiting Delivery", "Transaction paid successfully, but is sitting in suspense waiting on the merchant to confirm delivery of the goods."),
    DISPUTED("Disputed", "Transaction has been disputed by the Customer and funds are being held in suspense until the dispute has been resolved."),
    REFUNDED("Refunded", "Funds were refunded back to the customer."),
    DELIVERED("Delivered", "The user or merchant has acknowledged delivery of the goods but the funds are still sitting in suspense awaiting the 24 hour confirmation window to close."),
    CREATED("Created", "Transaction has been created in Paynow, but has not yet been paid by the customer."),
    ERROR("Error", "Transaction initiation request failed."),
    INVALID_ID("Invalid id.", "Transaction not initiated. Merchant supplied an invalid integration."),
    UNDEFINED("unknown", "Transaction status is not defined in this SDK or the transaction status does not exist. See raw response for actual status.");

    private String responseString;
    private String description;

    private TransactionStatus(String responseString, String description) {
        this.responseString = responseString;
        this.description = description;
    }

    public static TransactionStatus getTransactionStatus(String responseString) {
        for (TransactionStatus transactionStatus : TransactionStatus.values()) {
            if (!transactionStatus.getResponseString().equalsIgnoreCase(responseString)) continue;
            return transactionStatus;
        }
        return UNDEFINED;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.responseString + ". " + this.description;
    }
}

