/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.core;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import zw.co.paynow.exceptions.HashGenerationFailedException;

public final class HashGenerator {
    public static String make(Map<String, String> values, String integrationKey) {
        String str = HashGenerator.concat(values).concat(integrationKey);
        return HashGenerator.generateHash(str);
    }

    public static String generateHash(String input) {
        String hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            digest.reset();
            digest.update(input.getBytes(StandardCharsets.UTF_8));
            hash = String.format("%040x", new BigInteger(1, digest.digest()));
            return hash.toUpperCase();
        }
        catch (Exception e) {
            throw new HashGenerationFailedException();
        }
    }

    private static String concat(Map<String, String> items) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : items.entrySet()) {
            if (pair.getKey().equalsIgnoreCase("hash")) continue;
            sb.append(pair.getValue());
        }
        return sb.toString();
    }

    public static boolean verify(Map<String, String> data, String integrationKey) {
        return HashGenerator.make(data, integrationKey).equalsIgnoreCase(data.get("hash"));
    }
}

