/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.core;

import java.math.BigDecimal;
import java.util.HashMap;
import zw.co.paynow.parsers.PaymentParser;

public class Payment {
    private boolean overrideDescription = false;
    private String cartDescription = "";
    private String authEmail = "";
    private String merchantReference;
    private HashMap<String, BigDecimal> cart;

    Payment(String merchantReference, String authEmail) {
        this.merchantReference = merchantReference;
        this.cart = new HashMap();
        this.authEmail = authEmail;
    }

    Payment(String merchantReference, HashMap<String, BigDecimal> cart, String authEmail) {
        this.merchantReference = merchantReference;
        this.cart = cart;
        this.authEmail = authEmail;
    }

    public final Payment add(String title, double amount) {
        this.cart.put(title, new BigDecimal(amount));
        return this;
    }

    public final Payment add(String title, int amount) {
        this.cart.put(title, new BigDecimal(amount));
        return this;
    }

    public final Payment add(String title, BigDecimal amount) {
        this.cart.put(title, amount);
        return this;
    }

    public final Payment remove(String title) {
        HashMap<String, BigDecimal> items = this.cart;
        if (items.containsKey(title)) {
            this.cart.remove(title);
        }
        return this;
    }

    protected BigDecimal calculateTotal() {
        return PaymentParser.addCollectionValues(this.cart).setScale(2, 4);
    }

    public void setCartDescription(String description) {
        this.cartDescription = description;
        this.overrideDescription = true;
    }

    public final HashMap<String, String> toDictionary() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("resulturl", "");
        map.put("returnurl", "");
        map.put("reference", this.merchantReference);
        map.put("amount", this.getTotal().toString());
        map.put("id", "");
        map.put("additionalinfo", this.getCartDescription());
        map.put("authemail", this.authEmail);
        map.put("status", "Message");
        return map;
    }

    public final BigDecimal getTotal() {
        return this.calculateTotal();
    }

    public boolean isOverrideDescription() {
        return this.overrideDescription;
    }

    public String getAuthEmail() {
        return this.authEmail;
    }

    public String getMerchantReference() {
        return this.merchantReference;
    }

    public HashMap<String, BigDecimal> getCart() {
        return this.cart;
    }

    public void setCart(HashMap<String, BigDecimal> cart) {
        this.cart = cart;
    }

    public String getCartDescription() {
        if (this.overrideDescription) {
            return this.cartDescription;
        }
        return PaymentParser.flattenCollection(this.cart).trim();
    }
}

