/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.core;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import zw.co.paynow.constants.MobileMoneyMethod;
import zw.co.paynow.core.HashGenerator;
import zw.co.paynow.core.Payment;
import zw.co.paynow.exceptions.ConnectionException;
import zw.co.paynow.exceptions.EmptyCartException;
import zw.co.paynow.exceptions.HashMismatchException;
import zw.co.paynow.exceptions.InvalidReferenceException;
import zw.co.paynow.http.HttpClient;
import zw.co.paynow.parsers.UrlParser;
import zw.co.paynow.responses.MobileInitResponse;
import zw.co.paynow.responses.StatusResponse;
import zw.co.paynow.responses.WebInitResponse;
import zw.co.paynow.validators.EmailValidator;

public class Paynow {
    private String resultUrl = "http://localhost";
    private String returnUrl = "http://localhost";
    private String integrationId;
    private String integrationKey;
    private HttpClient httpHttpClient;

    public Paynow(String integrationId, String integrationKey) {
        this(integrationId, integrationKey, null);
    }

    public Paynow(String integrationId, String integrationKey, String resultUrl) {
        if (integrationId.isEmpty()) {
            throw new IllegalArgumentException("Integration id cannot be empty");
        }
        if (integrationKey.isEmpty()) {
            throw new IllegalArgumentException("Integration key cannot be empty");
        }
        this.integrationId = integrationId;
        this.integrationKey = integrationKey;
        if (resultUrl != null) {
            this.resultUrl = resultUrl;
        }
        this.httpHttpClient = new HttpClient();
    }

    public final Payment createPayment(String merchantReference, HashMap<String, BigDecimal> cart) {
        return this.createPayment(merchantReference, cart, "");
    }

    public final Payment createPayment(String merchantReference, String email) {
        return this.createPayment(merchantReference, null, email);
    }

    public final Payment createPayment(String merchantReference) {
        return this.createPayment(merchantReference, null, "");
    }

    public final Payment createPayment(String merchantReference, HashMap<String, BigDecimal> cart, String authEmail) {
        return cart != null ? new Payment(merchantReference, cart, authEmail) : new Payment(merchantReference, authEmail);
    }

    public final WebInitResponse send(Payment payment) {
        this.validatePayment(payment);
        return this.initWebTransaction(payment);
    }

    private void validatePayment(Payment payment) {
        if (payment.getMerchantReference().isEmpty()) {
            throw new InvalidReferenceException();
        }
        if (payment.getTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EmptyCartException();
        }
    }

    private void verifyHash(HashMap<String, String> data) {
        if (!data.containsKey("hash") || !HashGenerator.verify(data, this.integrationKey)) {
            throw new HashMismatchException(data.get("Error"));
        }
    }

    public final StatusResponse pollTransaction(String url) throws HashMismatchException, ConnectionException {
        try {
            String response = this.httpHttpClient.postAsync(url, null);
            return this.parseStatus(response);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.getMessage());
        }
    }

    protected StatusResponse parseStatus(String response) throws HashMismatchException {
        LinkedHashMap<String, String> data = UrlParser.parseMapFromQueryString(response);
        this.verifyHash(data);
        return new StatusResponse(data);
    }

    protected final StatusResponse parseStatus(HashMap<String, String> response) {
        this.verifyHash(response);
        return new StatusResponse(response);
    }

    public final MobileInitResponse sendMobile(Payment payment, String phone, MobileMoneyMethod mMoneyMethod) {
        this.validatePayment(payment);
        return this.initMobileTransaction(payment, phone, mMoneyMethod);
    }

    private MobileInitResponse initMobileTransaction(Payment payment, String phone, MobileMoneyMethod mMoneyMethod) throws ConnectionException, HashMismatchException {
        try {
            HashMap<String, String> data = this.formatInitMobileTransactionRequest(payment, phone, mMoneyMethod);
            String email = data.get("authemail");
            if (email == null || email.isEmpty() || !EmailValidator.validateEmail(email)) {
                throw new IllegalArgumentException("Auth email is required for mobile transactions. Please pass a valid email address to the createPayment method");
            }
            LinkedHashMap<String, String> response = UrlParser.parseMapFromQueryString(this.httpHttpClient.postAsync("https://www.paynow.co.zw/interface/remotetransaction", data));
            if (!(((String)((HashMap)response).get("status")).equalsIgnoreCase("error") || response.containsKey("hash") && HashGenerator.verify(response, this.integrationKey))) {
                throw new HashMismatchException((String)((HashMap)response).get("Error"));
            }
            return new MobileInitResponse(response);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.getMessage());
        }
    }

    private WebInitResponse initWebTransaction(Payment payment) throws ConnectionException, HashMismatchException {
        try {
            HashMap<String, String> data = this.formatInitWebTransactionRequest(payment);
            LinkedHashMap<String, String> response = UrlParser.parseMapFromQueryString(this.httpHttpClient.postAsync("https://www.paynow.co.zw/interface/initiatetransaction", data));
            if (!(((String)((HashMap)response).get("status")).equalsIgnoreCase("error") || response.containsKey("hash") && HashGenerator.verify(response, this.integrationKey))) {
                throw new HashMismatchException((String)((HashMap)response).get("Error"));
            }
            return new WebInitResponse(response);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.getMessage());
        }
    }

    private HashMap<String, String> formatInitWebTransactionRequest(Payment payment) {
        HashMap<String, String> items = payment.toDictionary();
        items.put("returnurl", this.returnUrl.trim());
        items.put("resulturl", this.resultUrl.trim());
        items.put("id", this.integrationId);
        items.put("hash", HashGenerator.make(items, this.integrationKey));
        return items;
    }

    private HashMap<String, String> formatInitMobileTransactionRequest(Payment payment, String phone, MobileMoneyMethod mMoneyMethod) {
        HashMap<String, String> items = payment.toDictionary();
        items.put("returnurl", this.returnUrl.trim());
        items.put("resulturl", this.resultUrl.trim());
        items.put("id", this.integrationId);
        items.put("phone", phone);
        items.put("method", mMoneyMethod.toString());
        items.put("hash", HashGenerator.make(items, this.integrationKey));
        return items;
    }

    public String getResultUrl() {
        return this.resultUrl;
    }

    public void setResultUrl(String resultUrl) {
        this.resultUrl = resultUrl;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getIntegrationId() {
        return this.integrationId;
    }

    public String getIntegrationKey() {
        return this.integrationKey;
    }

    protected HttpClient getHttpHttpClient() {
        return this.httpHttpClient;
    }

    public void setHttpHttpClient(HttpClient httpHttpClient) {
        this.httpHttpClient = httpHttpClient;
    }
}

