/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.parsers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class UrlParser {
    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String parseQueryStringFromMap(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", UrlParser.urlEncode(entry.getKey().toString()), UrlParser.urlEncode(entry.getValue().toString())));
        }
        return sb.toString();
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    public static LinkedHashMap<String, String> parseMapFromQueryString(String qs) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        if (qs.length() > 1) {
            String[] pairs;
            for (String pair : pairs = qs.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(UrlParser.urlDecode(pair.substring(0, idx)), UrlParser.urlDecode(pair.substring(idx + 1)));
            }
        }
        return queryPairs;
    }
}

