/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.responses;

import java.util.Map;
import zw.co.paynow.constants.TransactionStatus;
import zw.co.paynow.exceptions.InvalidIntegrationException;
import zw.co.paynow.responses.PaynowResponse;

public abstract class InitResponse
extends PaynowResponse {
    protected final String pollUrl;
    protected final String hash;

    public InitResponse(Map<String, String> response) throws InvalidIntegrationException {
        this.rawResponseContent = response;
        this.requestSuccess = this.rawResponseContent.containsKey("status") ? ((String)this.rawResponseContent.get("status")).equalsIgnoreCase(TransactionStatus.OK.getResponseString()) : false;
        if (this.rawResponseContent.containsKey("status")) {
            String rawStatus = (String)this.rawResponseContent.get("status");
            this.status = TransactionStatus.getTransactionStatus(rawStatus);
        } else {
            this.status = TransactionStatus.UNDEFINED;
        }
        this.hash = this.rawResponseContent.containsKey("hash") ? (String)this.rawResponseContent.get("hash") : "";
        this.pollUrl = this.rawResponseContent.containsKey("pollurl") ? (String)this.rawResponseContent.get("pollurl") : "";
        if (this.requestSuccess) {
            return;
        }
        if (this.rawResponseContent.containsKey("error")) {
            this.fail((String)this.rawResponseContent.get("error"));
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getPollUrl() {
        return this.pollUrl;
    }

    public String pollUrl() {
        return this.getPollUrl();
    }
}

