/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.responses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zw.co.paynow.constants.TransactionStatus;
import zw.co.paynow.exceptions.InvalidIntegrationException;

public abstract class PaynowResponse {
    protected Map<String, String> rawResponseContent;
    protected TransactionStatus status;
    protected boolean requestSuccess;
    private final ArrayList<String> errors = new ArrayList();

    public void fail(String error) {
        if (error.equalsIgnoreCase(TransactionStatus.INVALID_ID.getResponseString())) {
            throw new InvalidIntegrationException();
        }
        this.errors.add(error);
    }

    public final String errors() {
        return this.errors(',');
    }

    private String errors(char separator) {
        StringBuilder sb = new StringBuilder();
        for (String s : this.errors) {
            sb.append(s);
            sb.append(separator);
        }
        return sb.toString();
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public boolean isRequestSuccess() {
        return this.requestSuccess;
    }

    public boolean success() {
        return this.isRequestSuccess();
    }

    public Map<String, String> getRawResponseContent() {
        return new HashMap<String, String>(this.rawResponseContent);
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    public ArrayList<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }
}

