/*
 * Decompiled with CFR 0.152.
 */
package zw.co.paynow.responses;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import zw.co.paynow.constants.TransactionStatus;
import zw.co.paynow.exceptions.InvalidIntegrationException;
import zw.co.paynow.responses.PaynowResponse;

public class StatusResponse
extends PaynowResponse {
    private final String merchantReference;
    private final String paynowReference;
    private final BigDecimal amount;
    private final boolean paid;

    public StatusResponse(Map<String, String> response) throws InvalidIntegrationException {
        this.rawResponseContent = response;
        this.requestSuccess = !this.rawResponseContent.containsKey("error");
        if (this.rawResponseContent.containsKey("status")) {
            String rawStatus = (String)this.rawResponseContent.get("status");
            this.status = TransactionStatus.getTransactionStatus(rawStatus);
            this.paid = ((String)this.rawResponseContent.get("status")).equalsIgnoreCase(TransactionStatus.PAID.getResponseString());
        } else {
            this.paid = false;
            this.status = TransactionStatus.UNDEFINED;
        }
        this.amount = this.rawResponseContent.containsKey("amount") ? new BigDecimal((String)this.rawResponseContent.get("amount")) : new BigDecimal(0);
        this.merchantReference = this.rawResponseContent.containsKey("reference") ? (String)this.rawResponseContent.get("reference") : "";
        this.paynowReference = this.rawResponseContent.containsKey("paynowreference") ? (String)this.rawResponseContent.get("paynowreference") : "";
        if (this.requestSuccess) {
            return;
        }
        if (this.rawResponseContent.containsKey("error")) {
            this.fail((String)this.rawResponseContent.get("error"));
        }
    }

    public final String pollUrl() {
        return this.rawResponseContent.containsKey("pollurl") ? (String)this.rawResponseContent.get("pollurl") : "";
    }

    public final String hash() {
        return this.rawResponseContent.containsKey("hash") ? (String)this.rawResponseContent.get("hash") : "";
    }

    public String getMerchantReference() {
        return this.merchantReference;
    }

    public String getPaynowReference() {
        return this.paynowReference;
    }

    public BigDecimal getAmount() {
        return new BigDecimal(this.amount.doubleValue()).round(new MathContext(2, RoundingMode.HALF_UP));
    }

    public boolean paid() {
        return this.isPaid();
    }

    public boolean isPaid() {
        return this.paid;
    }
}

